/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.jdbc;

import com.agimatec.jdbc.JdbcDatabase;
import com.agimatec.jdbc.JdbcException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JdbcDatabaseImpl
implements JdbcDatabase {
    protected static final Logger log = LoggerFactory.getLogger(JdbcDatabaseImpl.class);
    private Connection connection;
    private final Properties properties = new Properties();
    private boolean autoCommit = false;

    public JdbcDatabaseImpl(Properties aProperties) {
        this.properties.putAll((Map<?, ?>)aProperties);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getDriverClassName() {
        return this.properties.getProperty("jdbcDriver");
    }

    public void begin() {
        if (this.isTransaction()) {
            throw new JdbcException("transaction already started");
        }
        if (this.connection == null) {
            this.connect();
        }
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        try {
            this.autoCommit = connection != null && connection.getAutoCommit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void connect() {
        try {
            if (log.isInfoEnabled()) {
                log.info("JdbcDriver: " + this.getDriverClassName() + "; JdbcConnect: " + this.getConnectionString() + "; properties: " + this.properties);
            }
            if (this.getDriverClassName() != null) {
                Class.forName(this.getDriverClassName());
            }
            this.setConnection(DriverManager.getConnection(this.getConnectionString(), this.properties));
        }
        catch (Exception e) {
            throw new JdbcException(e);
        }
    }

    public boolean isTransaction() {
        return this.connection != null && !this.autoCommit;
    }

    public void rollback() {
        if (this.isTransaction()) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
        }
    }

    public void commit() {
        if (this.isTransaction()) {
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getConnectionString() {
        return this.properties.getProperty("jdbcUrl");
    }

    public void close() {
        if (this.connection != null) {
            Connection tc = this.connection;
            this.connection = null;
            try {
                tc.close();
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
        }
    }

    public void init(String driver, String url, Properties props) {
        if (driver != null) {
            this.properties.setProperty("jdbcDriver", driver);
        }
        if (url != null) {
            this.properties.setProperty("jdbcUrl", url);
        }
        this.properties.putAll((Map<?, ?>)props);
    }
}

