/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql;

import com.agimatec.sql.AliasDictionary;
import com.agimatec.sql.SQLStatement;
import com.agimatec.sql.SQLStringGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class SQLWriter
extends Writer {
    private StringWriter selectStream;
    private StringWriter stream = new StringWriter();
    private AliasDictionary aliases;
    protected static final char parameterMarker = '?';
    private List parameters;
    private byte operatorState;
    public static final byte STATE_BEGIN = 0;
    public static final byte STATE_HAS_OP = 1;
    public static final byte STATE_NEEDS_OP = 2;

    public SQLWriter() {
        this(new AliasDictionary());
    }

    public SQLWriter(AliasDictionary useAliases) {
        this.selectStream = new StringWriter();
        this.aliases = useAliases;
        this.operatorState = 0;
        this.parameters = new ArrayList();
    }

    public void flipStreams() {
        StringWriter temp = this.stream;
        this.stream = this.selectStream;
        this.selectStream = temp;
    }

    public void close() {
    }

    public void flush() {
    }

    public AliasDictionary getAliases() {
        return this.aliases;
    }

    public void setAliases(AliasDictionary aAliases) {
        this.aliases = aAliases;
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            writer.write(this.getSelectString());
            this.getAliases().appendAliasListTo(writer);
            writer.write(this.getWhereString());
            return writer.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public String getSelectString() {
        return this.selectStream.toString();
    }

    public String getWhereString() {
        return this.stream.toString();
    }

    public String getParameterizedStatement() {
        try {
            StringWriter writer = new StringWriter();
            SQLStringGenerator sqlGen = new SQLStringGenerator(this.toString(), writer, this.getParameters());
            sqlGen.parse();
            return writer.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public SQLStatement createStatement() {
        return new SQLStatement(this.toString(), this.getParameters());
    }

    public void write(char[] cbuf, int off, int len) {
        this.stream.write(cbuf, off, len);
        this.operatorState = (byte)2;
    }

    public void write(int c) {
        this.stream.write(c);
        this.operatorState = (byte)2;
    }

    public void write(String str) {
        this.stream.write(str);
        this.operatorState = (byte)2;
    }

    public SQLWriter onSelect_write(String str) {
        this.selectStream.write(str);
        return this;
    }

    public void setOperatorState(byte aState) {
        this.operatorState = aState;
    }

    public byte getOperatorState() {
        return this.operatorState;
    }

    public void write(String str, int off, int len) {
        this.stream.write(str, off, len);
        this.operatorState = (byte)2;
    }

    public SQLWriter writeAnd() {
        return this.writeOperator(" AND ");
    }

    public SQLWriter writeOperator(String operator) {
        if (this.operatorState == 0) {
            this.writeWhere();
        } else if (this.operatorState == 2) {
            this.stream.write(operator);
            this.operatorState = 1;
        }
        return this;
    }

    public SQLWriter writeOr() {
        return this.writeOperator(" OR ");
    }

    public SQLWriter writeParameterMarker() {
        this.write(63);
        return this;
    }

    public SQLWriter addParameter(Object paramValue) {
        this.parameters.add(paramValue);
        return this.writeParameterMarker();
    }

    public List getParameters() {
        return this.parameters;
    }

    public SQLWriter writeWhere() {
        if (this.operatorState == 0 || this.operatorState == 2) {
            this.stream.write(" WHERE ");
            this.operatorState = 1;
        }
        return this;
    }
}

