/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.checking;

import com.agimatec.dbmigrate.action.ScriptAction;
import com.agimatec.jdbc.JdbcDatabase;
import com.agimatec.jdbc.JdbcException;
import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.ForeignKeyDescription;
import com.agimatec.sql.meta.IndexDescription;
import com.agimatec.sql.meta.TableDescription;
import com.agimatec.sql.meta.mysql.MySqlSchemaChecker;
import com.agimatec.sql.meta.oracle.OracleSchemaChecker;
import com.agimatec.sql.meta.postgres.PostgresSchemaChecker;
import com.agimatec.sql.meta.script.DDLScriptSqlMetaFactory;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseSchemaChecker {
    protected static final Logger logger = LoggerFactory.getLogger(DatabaseSchemaChecker.class);
    protected final List myFoundErrors = new ArrayList();
    protected JdbcDatabase database;
    protected Map unknownColumns;

    public static DatabaseSchemaChecker forDbms(String dbms) {
        if (dbms.equalsIgnoreCase("oracle")) {
            return new OracleSchemaChecker();
        }
        if (dbms.equalsIgnoreCase("postgres")) {
            return new PostgresSchemaChecker();
        }
        if (dbms.equalsIgnoreCase("mysql")) {
            return new MySqlSchemaChecker();
        }
        return null;
    }

    public JdbcDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(JdbcDatabase aDatabase) {
        this.database = aDatabase;
    }

    public void addUnmappedColumn(String tableName, String columnName) {
        HashSet<String> c = (HashSet<String>)this.getUnmappedColumns().get(tableName.toUpperCase());
        if (c == null) {
            c = new HashSet<String>();
            this.getUnmappedColumns().put(tableName.toUpperCase(), c);
        }
        c.add(columnName);
    }

    public Map getUnmappedColumns() {
        if (this.unknownColumns == null) {
            this.unknownColumns = new HashMap();
        }
        return this.unknownColumns;
    }

    public Collection getUnmappedColumns(String tableName) {
        Collection c = (Collection)this.getUnmappedColumns().get(tableName.toUpperCase());
        if (c == null) {
            return Collections.EMPTY_SET;
        }
        return c;
    }

    protected void throwAssertions() {
        if (!this.myFoundErrors.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.myFoundErrors.size(); ++i) {
                String s = (String)this.myFoundErrors.get(i);
                buf.append(i + 1).append("> ").append(s).append("\n\r");
            }
            throw new JdbcException(buf.toString());
        }
    }

    public abstract void assertObjectsValid() throws Exception;

    public void checkDatabaseSchema(URL[] scripts) throws Exception {
        this.checkDatabaseSchema(Collections.EMPTY_LIST, scripts);
    }

    public void checkDatabaseSchema(List<Options> options, URL[] scripts) throws Exception {
        DDLScriptSqlMetaFactory factory = this.getDDLScriptSqlMetaFactory();
        int idx = 0;
        for (URL script : scripts) {
            Options option = options != null && options.size() > idx ? options.get(idx++) : null;
            factory.fillCatalog(script, option == null ? null : option.format);
        }
        CatalogDescription expectedCatalog = factory.getCatalog();
        if (expectedCatalog == null) {
            this.assertTrue("No expected Catalog: neither schemaconfig nor scripts given!", false);
            this.throwAssertions();
        } else {
            CatalogDescription databaseCatalog = this.readDatabaseCatalog(expectedCatalog.getTableNames());
            this.print("Checking Database Schema " + databaseCatalog.getSchemaName() + "..");
            this.assertCatalogsComplete(expectedCatalog, databaseCatalog);
            this.print("Schema : Check OK");
        }
    }

    protected abstract DDLScriptSqlMetaFactory getDDLScriptSqlMetaFactory();

    protected abstract CatalogDescription readDatabaseCatalog(String[] var1) throws SQLException, IOException;

    public void assertCatalogsComplete(CatalogDescription schemaConfig, CatalogDescription databaseConfig) {
        String[] tables;
        this.myFoundErrors.clear();
        for (String theTable : tables = schemaConfig.getTableNames()) {
            TableDescription xmlTableDescription = schemaConfig.getTable(theTable);
            TableDescription databaseTableDescription = databaseConfig.getTable(xmlTableDescription.getTableName().toUpperCase());
            if (databaseTableDescription != null) {
                this.log("Checking " + databaseTableDescription.getTableName() + "...");
                this.compareSingleIndexDescription(xmlTableDescription.getPrimaryKey(), databaseTableDescription.getPrimaryKey());
                this.compareColumnDescription(xmlTableDescription, databaseTableDescription);
                this.compareIndexDescription(xmlTableDescription, databaseTableDescription);
                this.compareForeignKeyDescription(xmlTableDescription, databaseTableDescription);
                this.checkUnknownColumns(databaseTableDescription, xmlTableDescription.getColumnNames());
                continue;
            }
            this.assertTrue("Table: " + xmlTableDescription.getTableName() + "... not found in databaseCatalog!", false);
        }
        this.throwAssertions();
    }

    private void checkUnknownColumns(TableDescription databaseTableDescription, String[] configColumns) {
        String[] dbColumns;
        Collection c = this.getUnmappedColumns(databaseTableDescription.getTableName());
        String[] unmappedColumns = c.toArray(new String[0]);
        for (String unmapped : c) {
            this.assertTrue(databaseTableDescription.getTableName() + "." + unmapped + " [declared as unknown, but] not in database", databaseTableDescription.getColumn(unmapped) != null);
        }
        for (String theDbColumn : dbColumns = databaseTableDescription.getColumnNames()) {
            if (this.containsIgnoreCase(unmappedColumns, theDbColumn)) continue;
            this.assertTrue("Table " + databaseTableDescription.getTableName() + " contains unknown column: '" + theDbColumn + "'", this.containsIgnoreCase(configColumns, theDbColumn));
        }
    }

    private boolean containsIgnoreCase(String[] arr, String val) {
        for (String each : arr) {
            if (!val.equalsIgnoreCase(each)) continue;
            return true;
        }
        return false;
    }

    protected void compareSingleIndexDescription(IndexDescription xmlIndexDescription, IndexDescription databaseIndexDescription) {
        if (xmlIndexDescription == null && databaseIndexDescription == null) {
            return;
        }
        if (xmlIndexDescription == null) {
            this.assertTrue("Table: " + databaseIndexDescription.getTableName() + "... IndexName not expected! " + databaseIndexDescription.getIndexName() + " databaseIndexName: " + databaseIndexDescription.getIndexName(), false);
            return;
        }
        if (databaseIndexDescription == null) {
            this.assertTrue("Table: " + xmlIndexDescription.getTableName() + "...DatabaseIndexName not found!! Expected IndexName: " + xmlIndexDescription.getIndexName(), false);
            return;
        }
        if (xmlIndexDescription.isFunctionBased() || databaseIndexDescription.isFunctionBased()) {
            this.log("function based not yet supported");
            return;
        }
        if (xmlIndexDescription.getIndexName() == null || xmlIndexDescription.getIndexName().equalsIgnoreCase(databaseIndexDescription.getIndexName())) {
            boolean columnsOK = this.indexColumnsEqual(xmlIndexDescription, databaseIndexDescription);
            if (!columnsOK) {
                this.assertTrue("Table: " + xmlIndexDescription.getTableName() + ", index: " + xmlIndexDescription.getIndexName() + "... Columns differ! expected: " + xmlIndexDescription.getColumns() + " but was " + databaseIndexDescription.getColumns(), false);
            }
        } else {
            this.assertTrue("Table: " + xmlIndexDescription.getTableName() + "... Wrong Indexname! Expected IndexName: " + xmlIndexDescription.getIndexName() + " databaseIndexName: " + databaseIndexDescription.getIndexName(), false);
        }
    }

    private boolean indexColumnsEqual(IndexDescription xmlIndexDescription, IndexDescription databaseIndexDescription) {
        boolean columnsOK;
        boolean bl = columnsOK = xmlIndexDescription.getColumnSize() == databaseIndexDescription.getColumnSize();
        if (columnsOK) {
            for (int i = 0; i < xmlIndexDescription.getColumnSize(); ++i) {
                String dbColumn;
                String xmlColumn = xmlIndexDescription.getColumn(i);
                if (xmlColumn.equalsIgnoreCase(dbColumn = databaseIndexDescription.getColumn(i))) {
                    this.assertTrue("Table: " + xmlIndexDescription.getTableName() + "... Wrong Orderdirection! Column:" + xmlIndexDescription.getColumn(i) + " expected OrderDirection: " + xmlIndexDescription.getOrderDirection(i) + " databaseOrderDirection: " + databaseIndexDescription.getOrderDirection(i), xmlIndexDescription.getOrderDirection(i) == databaseIndexDescription.getOrderDirection(i));
                    continue;
                }
                columnsOK = false;
            }
        }
        return columnsOK;
    }

    protected void compareIndexDescription(TableDescription xmlTableDescription, TableDescription databaseTableDescription) {
        for (int i = 0; i < xmlTableDescription.getIndexSize(); ++i) {
            IndexDescription xmlIndexDescription = xmlTableDescription.getIndex(i);
            IndexDescription databaseIndexDescription = null;
            if (xmlIndexDescription.getIndexName() != null) {
                databaseIndexDescription = databaseTableDescription.getIndex(xmlIndexDescription.getIndexName());
            } else {
                for (IndexDescription each : databaseTableDescription.getIndices()) {
                    if (!this.indexColumnsEqual(xmlIndexDescription, each)) continue;
                    databaseIndexDescription = each;
                    break;
                }
                if (databaseIndexDescription == null) {
                    databaseIndexDescription = databaseTableDescription.getPrimaryKey();
                }
            }
            this.compareSingleIndexDescription(xmlIndexDescription, databaseIndexDescription);
        }
    }

    private void compareColumnDescription(TableDescription xmlTableDescription, TableDescription databaseTableDescription) {
        String tableName = xmlTableDescription.getTableName();
        for (int i = 0; i < xmlTableDescription.getColumnSize(); ++i) {
            ColumnDescription xmlColumnDescription = xmlTableDescription.getColumn(i);
            ColumnDescription databaseColumnDescription = databaseTableDescription.getColumn(xmlColumnDescription.getColumnName());
            this.assertTrue(xmlTableDescription + "." + xmlColumnDescription + " not in database.", databaseColumnDescription != null);
            if (databaseColumnDescription == null) continue;
            this.assertTrue("Table: " + tableName + ", ColumnName: " + xmlColumnDescription.getColumnName() + "... Wrong Precision! Expected Precision: " + xmlColumnDescription.getPrecision() + " databasePrecision: " + databaseColumnDescription.getPrecision(), this.isPrecisionCompatible(xmlColumnDescription, databaseColumnDescription));
            this.assertTrue("Table: " + tableName + ", ColumnName: " + xmlColumnDescription.getColumnName() + "... Wrong Scale! Expected Scale: " + xmlColumnDescription.getScale() + " databaseScale: " + databaseColumnDescription.getScale(), this.isScaleCompatible(xmlColumnDescription, databaseColumnDescription));
            this.assertTrue("Table: " + tableName + ", ColumnName: " + xmlColumnDescription.getColumnName() + "... Wrong Type! Expected Type: " + xmlColumnDescription.getTypeName() + " databaseType: " + databaseColumnDescription.getTypeName(), this.isTypeCompatible(xmlColumnDescription, databaseColumnDescription));
            this.assertTrue("Table: " + tableName + ", ColumnName: " + xmlColumnDescription.getColumnName() + "... : expected " + this.nullable(xmlColumnDescription.isNullable()) + " but was " + this.nullable(databaseColumnDescription.isNullable()), xmlColumnDescription.isNullable() == databaseColumnDescription.isNullable());
        }
    }

    private String nullable(boolean value) {
        return value ? "NULL" : "NOT NULL";
    }

    protected boolean isTypeCompatible(ColumnDescription expected, ColumnDescription actual) {
        return expected.getTypeName().equalsIgnoreCase(actual.getTypeName());
    }

    protected boolean isScaleCompatible(ColumnDescription expected, ColumnDescription actual) {
        return expected.getScale() == actual.getScale();
    }

    protected boolean isPrecisionCompatible(ColumnDescription expected, ColumnDescription actual) {
        return expected.getPrecision() == actual.getPrecision();
    }

    protected void compareForeignKeyDescription(TableDescription xmlTableDescription, TableDescription databaseTableDescription) {
        String tableName = xmlTableDescription.getTableName();
        ArrayList<ForeignKeyDescription> unCheckedDatabaseFKs = new ArrayList<ForeignKeyDescription>();
        if (databaseTableDescription.getForeignKeys() != null) {
            unCheckedDatabaseFKs.addAll(databaseTableDescription.getForeignKeys());
        }
        for (int i = 0; i < xmlTableDescription.getForeignKeySize(); ++i) {
            ForeignKeyDescription xmlForeignKeyDescription = xmlTableDescription.getForeignKey(i);
            if (xmlForeignKeyDescription.getConstraintName() == null || xmlForeignKeyDescription.getConstraintName().length() == 0) {
                this.log("cannot check unnamed foreign key in " + xmlForeignKeyDescription.getTableName() + " referencing " + xmlForeignKeyDescription.getRefTableName());
                continue;
            }
            ForeignKeyDescription databaseForeignKeyDescription = databaseTableDescription.getForeignKey(xmlForeignKeyDescription.getConstraintName());
            unCheckedDatabaseFKs.remove(databaseForeignKeyDescription);
            if (databaseForeignKeyDescription != null) {
                this.assertTrue("Table: " + tableName + "... Wrong ConstraintName! Expected ConstraintName: " + xmlForeignKeyDescription.getConstraintName() + " databaseConstraintName: " + databaseForeignKeyDescription.getConstraintName(), xmlForeignKeyDescription.getConstraintName().equalsIgnoreCase(databaseForeignKeyDescription.getConstraintName()));
                this.assertTrue("Table: " + tableName + ", ConstraintName: " + xmlForeignKeyDescription.getConstraintName() + "... Wrong ReferencedTable! Expected RefTable: " + xmlForeignKeyDescription.getRefTableName() + " databaseRefTable: " + databaseForeignKeyDescription.getRefTableName(), xmlForeignKeyDescription.getRefTableName().equalsIgnoreCase(databaseForeignKeyDescription.getRefTableName()));
                for (int j = 0; j < xmlForeignKeyDescription.getColumnSize(); ++j) {
                    String xmlColumn = xmlForeignKeyDescription.getColumn(j);
                    String xmlRefColumn = xmlForeignKeyDescription.getRefColumn(j);
                    this.assertTrue("Table: " + tableName + ", ConstraintName: " + xmlForeignKeyDescription.getConstraintName() + "... Column not found! Expected Column: " + xmlColumn, databaseForeignKeyDescription.getColumn(xmlColumn) != -1);
                    if (xmlRefColumn == null) continue;
                    this.assertTrue("Table: " + tableName + ", ConstraintName: " + xmlForeignKeyDescription.getConstraintName() + "... ReferencedColumn not found! Expected Column: " + xmlRefColumn, databaseForeignKeyDescription.getRefColumn(xmlRefColumn) != -1);
                }
                continue;
            }
            this.assertTrue("Table: " + tableName + "... ConstraintName not found! Expected ConstraintName: " + xmlForeignKeyDescription.getConstraintName(), false);
        }
        for (ForeignKeyDescription uncheckedFK : unCheckedDatabaseFKs) {
            this.assertTrue("Table: " + tableName + " contains unexpected foreign key constaint named '" + uncheckedFK + " on columns " + uncheckedFK.getColumns() + "' referencing table '" + uncheckedFK.getRefTableName() + "'", false);
        }
    }

    protected void assertTrue(String s, boolean b) {
        if (!b) {
            this.myFoundErrors.add(s);
        }
    }

    protected void print(Object obj) {
        this.log(obj);
        System.out.println(obj);
    }

    protected void log(Object obj) {
        if (logger != null) {
            if (obj instanceof Throwable) {
                logger.error(null, (Throwable)obj);
            } else {
                logger.info(String.valueOf(obj));
            }
        }
    }

    public static class Options {
        public ScriptAction.FileFormat format = ScriptAction.FileFormat.SQL;
    }
}

