/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.mysql;

import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.checking.DatabaseSchemaChecker;
import com.agimatec.sql.meta.mysql.MySqlJdbcMetaFactory;
import com.agimatec.sql.meta.script.DDLExpressions;
import com.agimatec.sql.meta.script.DDLScriptSqlMetaFactory;
import java.io.IOException;
import java.sql.SQLException;

public class MySqlSchemaChecker
extends DatabaseSchemaChecker {
    public void assertObjectsValid() throws Exception {
    }

    protected DDLScriptSqlMetaFactory getDDLScriptSqlMetaFactory() {
        return new DDLScriptSqlMetaFactory(DDLExpressions.forDbms("mysql"));
    }

    protected CatalogDescription readDatabaseCatalog(String[] tableNames) throws SQLException, IOException {
        MySqlJdbcMetaFactory factory = new MySqlJdbcMetaFactory(this.getDatabase());
        return factory.buildCatalog(tableNames);
    }

    protected boolean isPrecisionCompatible(ColumnDescription expected, ColumnDescription actual) {
        int xmlPrecision = expected.getPrecision();
        if (xmlPrecision == 0 && "BIGINT".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 20;
        }
        if (xmlPrecision == 0 && "SMALLINT".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 6;
        }
        if (xmlPrecision == 0 && "DOUBLE".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 22;
        }
        if (xmlPrecision == 0 && "TEXT".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 65535;
        }
        if (xmlPrecision == 0 && "MEDIUMTEXT".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 0xFFFFFF;
        }
        if (xmlPrecision == 0 && "FLOAT".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = 12;
        }
        if (xmlPrecision == 0 && "LONGBLOB".equalsIgnoreCase(expected.getTypeName())) {
            xmlPrecision = Integer.MAX_VALUE;
        }
        return xmlPrecision == actual.getPrecision();
    }
}

