/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.oracle;

import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.TableDescription;
import com.agimatec.sql.query.JdbcResultBuilder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class ColumnDescriptionBuilder
implements JdbcResultBuilder {
    private static final int C_COLUMN_NAME = 1;
    private static final int C_DATA_TYPE = 2;
    private static final int C_CHAR_LENGTH = 3;
    private static final int C_DATA_PRECISION = 4;
    private static final int C_DATA_SCALE = 5;
    private static final int C_NULLABLE = 6;
    private static final int C_TABLE_NAME = 7;
    private static final int C_DATA_TYPE_OWNER = 8;
    private CatalogDescription catalog;

    public void afterExecute(ResultSetMetaData data, Object queryObject, List resultList) throws SQLException {
        this.catalog = (CatalogDescription)queryObject;
    }

    public void fetch(ResultSet row) throws SQLException {
        ColumnDescription column = new ColumnDescription();
        String tableName = row.getString(7);
        TableDescription table = this.catalog.getTable(tableName);
        if (table != null) {
            column.setColumnName(row.getString(1));
            column.setNullable(!"N".equals(row.getString(6)));
            column.setTypeName(row.getString(2));
            String owner = row.getString(8);
            if (StringUtils.isNotEmpty((String)owner)) {
                column.setTypeName(owner.trim() + "." + column.getTypeName());
            }
            if ("TIMESTAMP(0)".equals(column.getTypeName())) {
                column.setTypeName("TIMESTAMP");
            }
            if (column.getTypeName().equals("VARCHAR2")) {
                column.setTypeName("VARCHAR");
            }
            if (this.isAnyOf(column.getTypeName(), new String[]{"VARCHAR", "CHAR", "RAW", "NVARCHAR2"})) {
                column.setPrecisionEnabled(true);
                column.setPrecision(row.getInt(3));
            } else if (column.getTypeName().equals("NUMBER")) {
                column.setPrecisionEnabled(true);
                column.setPrecision(row.getInt(4));
                column.setScale(row.getInt(5));
            }
            table.addColumn(column);
        }
    }

    private boolean isAnyOf(String value, String[] values) {
        return ArrayUtils.indexOf((Object[])values, (Object)value, (int)0) > -1;
    }

    public void close(boolean isComplete) {
    }
}

