/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.oracle;

import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.IndexDescription;
import com.agimatec.sql.meta.TableDescription;
import com.agimatec.sql.query.JdbcResultBuilder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class IndexDescriptionBuilder
implements JdbcResultBuilder {
    private static final int C_INDEX_NAME = 1;
    private static final int C_TABLE = 2;
    private static final int C_TABLESPACE_NAME = 3;
    private static final int C_INDEX_TYPE = 4;
    private static final int C_UNIQUENESS = 5;
    private static final int C_COLUMN_NAME = 6;
    private static final int C_DESCEND = 7;
    private static final int C_CONSTRAINT_TYPE = 8;
    private IndexDescription index;
    private CatalogDescription catalog;
    private String constraintType;

    public void afterExecute(ResultSetMetaData data, Object queryObject, List resultList) throws SQLException {
        this.index = null;
        this.catalog = (CatalogDescription)queryObject;
    }

    public void fetch(ResultSet row) throws SQLException {
        String idxName = row.getString(1);
        if (this.index == null || !this.index.getIndexName().equals(idxName)) {
            String type;
            if (this.index != null) {
                this.addIndex();
            }
            this.index = new IndexDescription();
            this.index.setIndexName(idxName);
            this.index.setTableName(row.getString(2));
            this.index.setTableSpace(row.getString(3));
            this.constraintType = row.getString(8);
            if ("UNIQUE".equals(row.getString(5))) {
                this.index.setUnique(true);
            }
            if ((type = row.getString(4)) == null) {
                type = "";
            }
            if (type.indexOf("DOMAIN") > -1) {
                this.index.setContext(true);
            }
            if (type.indexOf("FUNCTION-BASED") > -1) {
                this.index.setFunctionBased(true);
            }
            if (type.indexOf("BITMAP") > -1) {
                this.index.setBitmap(true);
            }
        }
        String order = "ASC";
        if ("DESC".equals(row.getString(7))) {
            order = "DESC";
        }
        this.index.addColumn(row.getString(6), order);
    }

    public void close(boolean isComplete) throws SQLException {
        if (this.index != null) {
            this.addIndex();
        }
    }

    private void addIndex() {
        TableDescription table = this.catalog.getTable(this.index.getTableName());
        if (table != null) {
            if (this.constraintType.equals("P")) {
                if (table.getPrimaryKey() != null) {
                    throw new IllegalArgumentException("only one primary key expected");
                }
                table.setPrimaryKey(this.index);
            } else if (table.getPrimaryKey() == null || !this.index.getIndexName().equals(table.getPrimaryKey().getIndexName())) {
                table.addIndex(this.index);
            }
        }
    }
}

