/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.oracle;

import com.agimatec.jdbc.JdbcDatabase;
import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.ForeignKeyDescription;
import com.agimatec.sql.meta.SequenceDescription;
import com.agimatec.sql.meta.SqlMetaFactory;
import com.agimatec.sql.meta.TableDescription;
import com.agimatec.sql.query.JdbcQueryUtil;
import com.agimatec.sql.query.QueryDefinition;
import com.agimatec.sql.query.SQLBuilder;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.xml.sax.SAXException;

public class OracleJdbcSqlMetaFactory
implements SqlMetaFactory {
    private final JdbcDatabase database;
    private JdbcQueryUtil queryUtil;
    private boolean sequences = false;
    private boolean indices = true;
    private boolean primaryKeys = true;
    private boolean columns = true;
    private boolean foreignKeys = true;
    private boolean comments = false;

    public boolean isSequences() {
        return this.sequences;
    }

    public void setSequences(boolean aSequences) {
        this.sequences = aSequences;
    }

    public boolean isIndices() {
        return this.indices;
    }

    public void setIndices(boolean aIndices) {
        this.indices = aIndices;
    }

    public boolean isPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(boolean aPrimaryKeys) {
        this.primaryKeys = aPrimaryKeys;
    }

    public boolean isColumns() {
        return this.columns;
    }

    public void setColumns(boolean aColumns) {
        this.columns = aColumns;
    }

    public boolean isForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(boolean aForeignKeys) {
        this.foreignKeys = aForeignKeys;
    }

    public boolean isComments() {
        return this.comments;
    }

    public void setComments(boolean aComments) {
        this.comments = aComments;
    }

    public OracleJdbcSqlMetaFactory(JdbcDatabase aDatabase) {
        this.database = aDatabase;
    }

    public CatalogDescription buildCatalog() throws SQLException, IOException, SAXException {
        return this.buildCatalog(this.loadTables());
    }

    public CatalogDescription buildCatalog(String[] tables) throws SQLException, IOException {
        CatalogDescription catalog = new CatalogDescription();
        catalog.setSchemaName(this.getSchemaName());
        this.addTables(tables, catalog);
        if (this.sequences && catalog.getSchemaName() != null) {
            this.addSequences(catalog);
        }
        return catalog;
    }

    private String getSchemaName() throws SQLException, IOException {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setMaxResults(1);
        queryDefinition.setQueryName("load-user");
        return (String)this.getQueryBean().executeQuery(queryDefinition).getFirst();
    }

    private void addSequences(CatalogDescription aCatalog) throws SQLException, IOException {
        SequenceDescription[] sequences;
        for (SequenceDescription sequence : sequences = this.loadSequences(aCatalog.getSchemaName())) {
            aCatalog.addSequence(sequence);
        }
    }

    private void addTables(String[] tables, CatalogDescription aCatalog) throws SQLException, IOException {
        TableDescription table;
        if (this.foreignKeys) {
            for (String table1 : tables) {
                ForeignKeyDescription[] fks;
                table = this.createTable(table1);
                aCatalog.addTable(table);
                for (ForeignKeyDescription fk : fks = this.loadForeignKeys(table.getTableName())) {
                    table.addForeignKey(fk);
                }
            }
            if (!this.comments || this.foreignKeys) {
                // empty if block
            }
        }
        if (this.columns) {
            this.buildColumns(aCatalog);
        }
        if (this.indices) {
            this.buildIndexes(aCatalog);
        }
        if (this.indices && this.primaryKeys) {
            this.buildPrimaryKeys(aCatalog);
        }
        if (this.columns) {
            for (String table1 : tables) {
                table = aCatalog.getTable(table1);
                if (table.getColumnSize() != 0) continue;
                aCatalog.removeTable(table1);
            }
        }
        if (this.comments) {
            this.loadTableComments(aCatalog);
            if (this.foreignKeys) {
                this.loadFKComments(aCatalog);
            }
            if (this.columns) {
                this.loadColumnComments(aCatalog);
            }
        }
    }

    private void loadColumnComments(CatalogDescription aCatalog) throws SQLException, IOException {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setQueryObject(aCatalog);
        queryDefinition.setQueryName("column_comments");
        this.getQueryBean().executeQuery(queryDefinition);
    }

    private void loadFKComments(CatalogDescription aCatalog) {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setQueryObject(aCatalog);
        queryDefinition.setQueryName("constraint_comments");
        try {
            this.getQueryBean().executeQuery(queryDefinition);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadTableComments(CatalogDescription aCatalog) throws SQLException, IOException {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setQueryObject(aCatalog);
        queryDefinition.setQueryName("table_comments");
        this.getQueryBean().executeQuery(queryDefinition);
    }

    private ForeignKeyDescription[] loadForeignKeys(String tablename) throws SQLException, IOException {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setQueryObject(tablename.toUpperCase());
        queryDefinition.setQueryName("foreign-keys-for-table");
        List l = this.getQueryBean().executeQuery(queryDefinition).getList();
        return l.toArray(new ForeignKeyDescription[l.size()]);
    }

    private TableDescription createTable(String tableName) throws SQLException {
        TableDescription tableDesc = new TableDescription();
        tableDesc.setTableName(tableName.toUpperCase());
        return tableDesc;
    }

    private void buildColumns(CatalogDescription aCatalog) throws SQLException, IOException {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setQueryObject(aCatalog);
        queryDefinition.setQueryName("user-columns");
        this.getQueryBean().executeQuery(queryDefinition).getList();
    }

    private void buildPrimaryKeys(CatalogDescription aCatalog) throws SQLException, IOException {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setQueryObject(aCatalog);
        queryDefinition.setQueryName("user-primary-keys");
        this.getQueryBean().executeQuery(queryDefinition).getList();
    }

    private void buildIndexes(CatalogDescription aCatalog) throws SQLException, IOException {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setQueryObject(aCatalog);
        queryDefinition.setQueryName("user-indices");
        this.getQueryBean().executeQuery(queryDefinition).getList();
    }

    private SequenceDescription[] loadSequences(String owner) throws SQLException, IOException {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setQueryObject(owner);
        queryDefinition.setQueryName("all-sequences-for-owner");
        List l = this.getQueryBean().executeQuery(queryDefinition).getList();
        return l.toArray(new SequenceDescription[l.size()]);
    }

    private String[] loadTables() throws SQLException, IOException {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setQueryName("load-tables");
        List l = this.getQueryBean().executeQuery(queryDefinition).getList();
        return l.toArray(new String[l.size()]);
    }

    private JdbcQueryUtil getQueryBean() throws IOException {
        if (this.queryUtil == null) {
            this.queryUtil = new JdbcQueryUtil(this.getDatabase().getConnection(), new SQLBuilder("com/agimatec/sql/meta/oracle-statements.properties"));
        }
        return this.queryUtil;
    }

    public JdbcDatabase getDatabase() {
        return this.database;
    }
}

