/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.oracle;

import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.checking.DatabaseSchemaChecker;
import com.agimatec.sql.meta.oracle.OracleJdbcSqlMetaFactory;
import com.agimatec.sql.meta.script.DDLExpressions;
import com.agimatec.sql.meta.script.DDLScriptSqlMetaFactory;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OracleSchemaChecker
extends DatabaseSchemaChecker {
    public void assertObjectsValid() throws Exception {
        this.assertIndexValid();
        this.assertTriggersValid();
        this.assertViewsValid();
    }

    protected DDLScriptSqlMetaFactory getDDLScriptSqlMetaFactory() {
        return new DDLScriptSqlMetaFactory(DDLExpressions.forDbms("oracle"));
    }

    protected CatalogDescription readDatabaseCatalog(String[] tableNames) throws SQLException, IOException {
        OracleJdbcSqlMetaFactory oracleFactory = new OracleJdbcSqlMetaFactory(this.getDatabase());
        return oracleFactory.buildCatalog(tableNames);
    }

    public void assertViewsValid() throws Exception {
        this.myFoundErrors.clear();
        this.assertObjectsValid("VIEW");
        this.throwAssertions();
    }

    public void assertIndexValid() throws Exception {
        this.myFoundErrors.clear();
        this.assertObjectsValid("INDEX");
        this.throwAssertions();
    }

    public void assertTriggersValid() throws Exception {
        this.myFoundErrors.clear();
        this.assertObjectsValid("TRIGGER");
        this.throwAssertions();
    }

    protected void assertObjectsValid(String objectType) throws Exception {
        this.print("Checking " + objectType + "..");
        Connection conn = this.getDatabase().getConnection();
        List invalidObjects = this.getInvalidObjects(objectType);
        if (!invalidObjects.isEmpty()) {
            Iterator iter = invalidObjects.iterator();
            if (!objectType.equalsIgnoreCase("INDEX")) {
                while (iter.hasNext()) {
                    String obj = (String)iter.next();
                    this.compileObject(conn, obj, objectType);
                }
                invalidObjects = this.getInvalidObjects(objectType);
                iter = invalidObjects.iterator();
            }
            StringBuilder buf = new StringBuilder();
            buf.append("Invalid ").append(objectType).append(" detected: ");
            while (iter.hasNext()) {
                String obj = (String)iter.next();
                buf.append(obj);
                if (!iter.hasNext()) continue;
                buf.append(", ");
            }
            this.assertTrue(buf.toString(), invalidObjects.isEmpty());
        }
        this.print(objectType + " checked.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileObject(Connection aConn, String aView, String objecttype) throws SQLException {
        Statement stmt = aConn.createStatement();
        try {
            stmt.execute("ALTER " + objecttype + " " + aView + " COMPILE");
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getInvalidObjects(String objectType) throws SQLException {
        if (objectType.equalsIgnoreCase("INDEX")) {
            return this.getInvalidIndex();
        }
        String stmtInvalidObjects = "SELECT OBJECT_NAME FROM USER_OBJECTS WHERE OBJECT_TYPE = '" + objectType + "' AND STATUS != 'VALID' ORDER BY OBJECT_NAME";
        ArrayList<String> invalidObjects = new ArrayList<String>();
        Connection conn = this.getDatabase().getConnection();
        Statement stmt = conn.createStatement();
        ResultSet resultSet = stmt.executeQuery(stmtInvalidObjects);
        try {
            while (resultSet.next()) {
                invalidObjects.add(resultSet.getString(1));
            }
        }
        finally {
            resultSet.close();
            stmt.close();
        }
        return invalidObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getInvalidIndex() throws SQLException {
        String stmtInvalidObjects = "select index_name, DOMIDX_STATUS from user_indexes where DOMIDX_OPSTATUS is not null and (DOMIDX_OPSTATUS <> 'VALID' or DOMIDX_STATUS   <> 'VALID')";
        ArrayList<String> invalidObjects = new ArrayList<String>();
        Connection conn = this.getDatabase().getConnection();
        Statement stmt = conn.createStatement();
        ResultSet resultSet = stmt.executeQuery(stmtInvalidObjects);
        try {
            while (resultSet.next()) {
                invalidObjects.add(resultSet.getString(1));
            }
        }
        finally {
            resultSet.close();
            stmt.close();
        }
        return invalidObjects;
    }
}

