/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.script;

import com.agimatec.commons.config.ConfigManager;
import com.agimatec.sql.meta.persistence.ObjectPersistencer;
import com.agimatec.sql.meta.persistence.SerializerPersistencer;
import com.agimatec.sql.meta.persistence.XStreamPersistencer;
import com.agimatec.sql.meta.script.DDLExpressions;
import com.agimatec.sql.meta.script.DDLScriptSqlMetaFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DDLParserTool {
    private String dbms;
    private List<String> scriptsToParse = new ArrayList<String>();
    private String catalog;

    public static void main(String[] args) throws Exception {
        DDLParserTool tool = new DDLParserTool();
        if (!tool.parseArgs(args)) {
            return;
        }
        tool.start();
    }

    private void start() throws Exception {
        DDLExpressions expressions = DDLExpressions.forDbms(this.dbms);
        if (expressions == null) {
            throw new IllegalArgumentException("unsupported dbms: " + this.dbms);
        }
        DDLScriptSqlMetaFactory factory = new DDLScriptSqlMetaFactory(expressions);
        for (String script : this.scriptsToParse) {
            factory.fillCatalog(ConfigManager.toURL(script));
        }
        ObjectPersistencer persistencer = this.catalog.toLowerCase().endsWith(".xml") ? new XStreamPersistencer() : new SerializerPersistencer();
        File p = new File(this.catalog).getParentFile();
        if (p != null) {
            p.mkdirs();
        }
        persistencer.save(factory.getCatalog(), new File(this.catalog));
    }

    private boolean parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-help".equalsIgnoreCase(arg)) {
                DDLParserTool.printUsage();
                return false;
            }
            if ("-dbms".equalsIgnoreCase(arg)) {
                if (this.dbms != null) {
                    throw new IllegalArgumentException("exactly one -dbms option is required!");
                }
                this.dbms = args[++i];
                continue;
            }
            if ("-parse".equalsIgnoreCase(arg)) {
                this.scriptsToParse.add(args[++i]);
                continue;
            }
            if (!"-catalog".equalsIgnoreCase(arg)) continue;
            if (this.catalog != null) {
                throw new IllegalArgumentException("exactly one -catalog option is required!");
            }
            this.catalog = args[++i];
        }
        this.checkValid();
        return true;
    }

    private void checkValid() {
        if (this.catalog == null) {
            throw new IllegalArgumentException("no catalog output file name given with option -catalog");
        }
        if (this.dbms == null) {
            throw new IllegalArgumentException("no database given with option -dbms");
        }
        if (this.scriptsToParse.isEmpty()) {
            throw new IllegalArgumentException("no scripts to parse given with option -parse");
        }
    }

    private static void printUsage() {
        System.out.println("usage: java " + DDLParserTool.class.getName() + " -catalog catalog.xml -dbms dbms -parse file:script-to-parse.sql");
        System.out.println("Options:\n\t-help \t (optional) print this help");
        System.out.println("\t-catalog \t (required) path of catalog file (xml or dmp) to write");
        System.out.println("\t-dbms \t (required) e.g. oracle, postgres. Determines the database syntax for the script parser.");
        System.out.println("\t-parse\t (required) can appear multiple times. a URL of a script to parse into the catalog, e.g. file:create-tables.sql - All scripts must belong to the same database schema catalog");
    }
}

