/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.script;

import com.agimatec.sql.meta.script.ExpBuildState;
import com.agimatec.sql.meta.script.ExtractExpr;
import com.agimatec.sql.meta.script.ExtractSeparator;
import com.agimatec.sql.script.WordTokenizer;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import org.apache.commons.lang.ArrayUtils;

public class ExtractExprBuilder {
    private final String input;
    private final WordTokenizer tokens;
    private static final String[] words = new String[]{"${", "{", "[", "(", "'?'", "'", "}", "]", ")", "...", " "};
    private ExtractExpr expression;
    private ExtractExpr current;
    private String word;

    protected ExtractExprBuilder(String aFormatString) {
        this.input = aFormatString;
        this.tokens = new WordTokenizer(new StringReader(this.input), words, true, true);
    }

    public static ExtractExpr buildExpr(String format) throws ParseException {
        ExtractExprBuilder builder;
        try {
            builder = new ExtractExprBuilder(format);
            builder.parse();
        }
        catch (IOException e) {
            throw new ParseException(format, 0);
        }
        return builder.getExpression();
    }

    private void parse() throws IOException, ParseException {
        this.nextWord();
        if (!this.isWord("{")) {
            throw this.parseException();
        }
        this.nextWord();
        this.current = this.expression = new ExtractExpr(this.word);
        ExpBuildState state = new ExpBuildState();
        this.parseExpression(state);
        this.nextWord();
        if (this.word != null) {
            throw this.parseException("premature end");
        }
    }

    private void parseExpression(ExpBuildState state) throws IOException, ParseException {
        this.nextWord();
        while (this.word != null && this.word != null) {
            int idx = ArrayUtils.indexOf((Object[])words, (Object)this.word, (int)0);
            switch (idx) {
                case 0: {
                    this.parseProperty(state);
                    break;
                }
                case 1: {
                    this.parseSubExpression(state);
                    break;
                }
                case 2: {
                    state.setOptional(true);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.current.addSeparator();
                    break;
                }
                case 5: {
                    this.current.addSeparator(this.parseSeparator());
                    break;
                }
                case 6: {
                    return;
                }
                case 7: {
                    state.setOptional(false);
                    break;
                }
                case 8: {
                    throw this.parseException();
                }
                case 9: {
                    this.parseRepeat();
                    break;
                }
                case 10: {
                    break;
                }
                case -1: {
                    if (state.isOptional()) {
                        this.current.addOptionalWord(this.word);
                        break;
                    }
                    this.current.addWord(this.word);
                    break;
                }
                default: {
                    throw new IllegalStateException("internal error, unknown token: " + this.word);
                }
            }
            this.nextWord();
        }
    }

    private void parseRepeat() throws IOException, ParseException {
        this.nextWord();
        if (this.isWord("'")) {
            String sep = this.parseSeparator();
            this.current.setRepeatSep(new ExtractSeparator(sep));
        } else if (this.isWord("'?'")) {
            this.current.setRepeatSep(new ExtractSeparator());
        } else {
            throw this.parseException("separator expected");
        }
    }

    private void parseSubExpression(ExpBuildState state) throws IOException, ParseException {
        ExtractExpr subExpr;
        ExtractExpr formerExpr = this.current;
        this.current = subExpr = new ExtractExpr(this.nextWord());
        this.parseExpression(new ExpBuildState());
        if (state.isOptional()) {
            formerExpr.addOptionalExpr(subExpr);
        } else {
            formerExpr.addExpr(subExpr);
        }
        this.current = formerExpr;
    }

    private String nextWord() throws IOException {
        this.word = this.tokens.nextToken();
        return this.word;
    }

    private void parseProperty(ExpBuildState state) throws IOException, ParseException {
        String propName = this.nextWord();
        this.nextWord();
        String pword = null;
        if (this.isWord("(")) {
            pword = this.parseUntil(")");
            this.nextWord();
        }
        if (this.isWord("{")) {
            String startDelim;
            String endDelim = startDelim = this.nextWord();
            if (!"}".equals(this.nextWord())) {
                throw this.parseException();
            }
            if ("{".equals(this.nextWord())) {
                endDelim = this.nextWord();
                if (!"}".equals(this.nextWord())) {
                    throw this.parseException();
                }
                this.nextWord();
            }
            this.current.addProperty(pword, propName, state.isOptional(), startDelim, endDelim);
        } else {
            if (!this.isWord("}")) {
                throw this.parseException();
            }
            if (state.isOptional()) {
                this.current.addOptionalProperty(pword, propName);
            } else {
                this.current.addProperty(pword, propName);
            }
        }
    }

    private boolean isWord(String s) {
        return s.equals(this.word);
    }

    private String parseSeparator() throws IOException, ParseException {
        return this.parseUntil("'");
    }

    private String parseUntil(String terminalToken) throws IOException, ParseException {
        StringBuilder sep = new StringBuilder();
        this.nextWord();
        while (!this.isWord(terminalToken) && this.word != null) {
            sep.append(this.word);
            this.nextWord();
        }
        if (this.word == null) {
            throw this.parseException("premature end, missing " + terminalToken);
        }
        return sep.toString();
    }

    private ParseException parseException() {
        return new ParseException(this.input + " at: " + this.word, 0);
    }

    private ParseException parseException(String s) {
        return new ParseException(s + " at: " + this.word, 0);
    }

    private ExtractExpr getExpression() {
        return this.expression;
    }
}

