/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.config;

import com.agimatec.commons.config.ListNode;
import com.agimatec.commons.config.MapNode;
import com.agimatec.commons.config.sax.ConfigWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class Node
implements Serializable {
    protected String name;

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public abstract Object getObjectValue();

    protected Object evaluatePath(StringTokenizer tokens, Object node) {
        do {
            String token = tokens.nextToken();
            if (node instanceof MapNode) {
                node = ((MapNode)node).get(token);
                continue;
            }
            if (node instanceof ListNode) {
                node = ((ListNode)node).get(Integer.parseInt(token));
                continue;
            }
            if (node instanceof Map) {
                node = ((Map)node).get(token);
                continue;
            }
            if (node instanceof List) {
                node = ((List)node).get(Integer.parseInt(token));
                continue;
            }
            throw new IllegalArgumentException("cannot access " + token + " from " + node);
        } while (node != null && tokens.hasMoreTokens());
        return node;
    }

    public String toString() {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            new ConfigWriter().writeConfig(this, pw);
            return sw.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString(String encoding) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.print("<?xml version=\"1.0\" encoding=\"");
            pw.print(encoding);
            pw.println("\"?>");
            new ConfigWriter().writeConfig(this, pw);
            return sw.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

