/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta;

import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.ForeignKeyDescription;
import com.agimatec.sql.meta.IndexDescription;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="table")
public class TableDescription
implements Serializable,
Cloneable {
    private String comment;
    private String tableName;
    private List<ColumnDescription> columns = new ArrayList<ColumnDescription>();
    private IndexDescription primaryKey;
    private List<IndexDescription> indices = new ArrayList<IndexDescription>();
    private List<IndexDescription> constraints = new ArrayList<IndexDescription>();
    private List<ForeignKeyDescription> foreignKeys = new ArrayList<ForeignKeyDescription>();
    private String catalogName;
    private String schemaName;

    public TableDescription deepCopy() {
        try {
            TableDescription clone = (TableDescription)this.clone();
            clone.columns = new ArrayList<ColumnDescription>(this.columns.size());
            for (ColumnDescription columnDescription : this.columns) {
                clone.columns.add(columnDescription.deepCopy());
            }
            clone.indices = new ArrayList<IndexDescription>(this.indices.size());
            for (IndexDescription indexDescription : this.indices) {
                clone.indices.add(indexDescription.deepCopy());
            }
            clone.constraints = new ArrayList<IndexDescription>(this.constraints.size());
            for (IndexDescription indexDescription : this.constraints) {
                clone.constraints.add(indexDescription.deepCopy());
            }
            clone.foreignKeys = new ArrayList<ForeignKeyDescription>(this.foreignKeys.size());
            for (ForeignKeyDescription foreignKeyDescription : this.foreignKeys) {
                clone.foreignKeys.add(foreignKeyDescription.deepCopy());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getQualifiedTableName() {
        StringBuilder qualifiedTableName = new StringBuilder();
        if (this.getSchemaName() != null) {
            qualifiedTableName.append(this.getSchemaName());
            qualifiedTableName.append(".");
        }
        if (this.getCatalogName() != null) {
            qualifiedTableName.append(this.getCatalogName());
            qualifiedTableName.append(".");
        }
        qualifiedTableName.append(this.getTableName());
        return qualifiedTableName.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String aTableName) {
        this.tableName = aTableName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String aComment) {
        this.comment = aComment;
    }

    public boolean isForeignKeyColumn(String columnName) {
        for (ForeignKeyDescription fk : this.getForeignKeys()) {
            if (!fk.containsColumn(columnName)) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimaryKeyColumn(String columnName) {
        if (this.getPrimaryKey() == null) {
            return false;
        }
        for (String pkCol : this.getPrimaryKey().getColumns()) {
            if (!pkCol.equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnique(List<String> columns) {
        List<IndexDescription> indices = this.findIndicesForColumns(columns);
        for (IndexDescription index : indices) {
            if (!index.isUnique()) continue;
            return true;
        }
        return false;
    }

    public boolean isUnique(String column) {
        ArrayList<String> columns = new ArrayList<String>(1);
        columns.add(column);
        return this.isUnique(columns);
    }

    public IndexDescription getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(IndexDescription aPrimaryKey) {
        this.primaryKey = aPrimaryKey;
    }

    public IndexDescription getIndex(String indexName) {
        for (IndexDescription indice : this.indices) {
            if (!indice.getIndexName().equalsIgnoreCase(indexName)) continue;
            return indice;
        }
        return null;
    }

    public void removeIndex(String indexName) {
        Iterator<IndexDescription> iter = this.indices.iterator();
        while (iter.hasNext()) {
            IndexDescription theindexDescription = iter.next();
            if (!theindexDescription.getIndexName().equalsIgnoreCase(indexName)) continue;
            iter.remove();
            return;
        }
    }

    public IndexDescription getConstraint(String indexName) {
        for (IndexDescription indice : this.constraints) {
            if (!indice.getIndexName().equalsIgnoreCase(indexName)) continue;
            return indice;
        }
        return null;
    }

    public void removeConstraint(String indexName) {
        Iterator<IndexDescription> iter = this.constraints.iterator();
        while (iter.hasNext()) {
            IndexDescription theindexDescription = iter.next();
            if (!theindexDescription.getIndexName().equalsIgnoreCase(indexName)) continue;
            iter.remove();
            return;
        }
    }

    public List<ForeignKeyDescription> getForeignKeys() {
        return this.foreignKeys;
    }

    public List<IndexDescription> getConstraints() {
        return this.constraints;
    }

    public List<IndexDescription> getIndices() {
        return this.indices;
    }

    public IndexDescription getIndex(int i) {
        return this.indices.get(i);
    }

    public int getIndexSize() {
        return this.indices.size();
    }

    public int getConstraintSize() {
        return this.constraints.size();
    }

    public void addIndex(IndexDescription aIndex) {
        this.indices.add(aIndex);
    }

    public void addConstraint(IndexDescription aIndex) {
        this.constraints.add(aIndex);
    }

    public IndexDescription getConstraint(int i) {
        return this.constraints.get(i);
    }

    public ForeignKeyDescription getForeignKey(String constraintName) {
        for (ForeignKeyDescription foreignKey : this.foreignKeys) {
            if (!foreignKey.getConstraintName().equalsIgnoreCase(constraintName)) continue;
            return foreignKey;
        }
        return null;
    }

    public ForeignKeyDescription findForeignKeyLike(ForeignKeyDescription other) {
        if (other.getConstraintName() == null || other.getConstraintName().length() == 0) {
            for (ForeignKeyDescription foreignKey : this.foreignKeys) {
                if (!foreignKey.isSimilarTo(other)) continue;
                return foreignKey;
            }
        } else {
            return this.getForeignKey(other.getConstraintName());
        }
        return null;
    }

    public ForeignKeyDescription getForeignKey(int i) {
        return this.foreignKeys.get(i);
    }

    public int getForeignKeySize() {
        return this.foreignKeys.size();
    }

    public void addForeignKey(ForeignKeyDescription aFK) {
        this.foreignKeys.add(aFK);
    }

    public String[] getColumnNames() {
        Object[] columnNames = new String[this.columns.size()];
        Iterator<ColumnDescription> iter = this.columns.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ColumnDescription theColumnDescription = iter.next();
            columnNames[i++] = theColumnDescription.getColumnName();
        }
        Arrays.sort(columnNames);
        return columnNames;
    }

    public List<ColumnDescription> getColumns() {
        return this.columns;
    }

    public ColumnDescription getColumn(int i) {
        return this.columns.get(i);
    }

    public ColumnDescription getColumn(String columnName) {
        for (ColumnDescription column : this.columns) {
            if (!column.getColumnName().equalsIgnoreCase(columnName)) continue;
            return column;
        }
        return null;
    }

    public void removeColumn(String columnName) {
        ColumnDescription colDesc = this.getColumn(columnName);
        if (colDesc != null) {
            this.columns.remove(colDesc);
        }
    }

    public int getColumnSize() {
        return this.columns.size();
    }

    public void addColumn(ColumnDescription aColumn) {
        this.columns.add(aColumn);
    }

    public String toString() {
        return this.getQualifiedTableName();
    }

    public IndexDescription findIndexForColumns(List<String> columns) {
        for (IndexDescription index : this.getIndices()) {
            if (!index.isSameColumns(columns)) continue;
            return index;
        }
        return null;
    }

    public IndexDescription findConstraintForColumns(List<String> columns) {
        if (this.primaryKey != null && this.primaryKey.isSameColumns(columns)) {
            return this.primaryKey;
        }
        for (IndexDescription index : this.getConstraints()) {
            if (!index.isSameColumns(columns)) continue;
            return index;
        }
        return null;
    }

    public List<IndexDescription> findIndicesForColumns(List<String> columns) {
        ArrayList<IndexDescription> indices = new ArrayList<IndexDescription>();
        if (this.getPrimaryKey() != null && this.getPrimaryKey().isSameColumns(columns)) {
            indices.add(this.getPrimaryKey());
        }
        for (IndexDescription index : this.getConstraints()) {
            if (!index.isSameColumns(columns) || !index.isUnique()) continue;
            indices.add(index);
        }
        for (IndexDescription index : this.getIndices()) {
            if (!index.isSameColumns(columns) || !index.isUnique()) continue;
            indices.add(index);
        }
        return indices;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }
}

