/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbtransform;

import com.agimatec.commons.config.MapNode;
import com.agimatec.commons.generator.FreemarkerFileGenerator;
import com.agimatec.dbtransform.CatalogConversion;
import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.ForeignKeyDescription;
import com.agimatec.sql.meta.IndexDescription;
import com.agimatec.sql.meta.TableDescription;
import com.agimatec.sql.meta.script.DDLExpressions;
import com.agimatec.sql.meta.script.DDLScriptSqlMetaFactory;
import com.agimatec.sql.meta.script.ExtractExpr;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptTransformator
extends DDLScriptSqlMetaFactory {
    private static final Logger log = LoggerFactory.getLogger(ScriptTransformator.class);
    private final PrintWriter target;
    private final CatalogConversion catalogConversion;
    private final FreemarkerFileGenerator templateEngine;

    public ScriptTransformator(DDLExpressions ddlSpecification, PrintWriter target, CatalogConversion catalogConversion, FreemarkerFileGenerator templateEngine) {
        super(ddlSpecification);
        this.target = target;
        this.catalogConversion = catalogConversion;
        this.templateEngine = templateEngine;
    }

    protected void init() {
        this.getBuilders().put("table-alter-columns", new TableAlterColumnsBuilder());
        this.getBuilders().put("drop-trigger", new DropTriggerBuilder());
        this.getBuilders().put("dezign-create-table", new TransformDezignCreateTableBuilder());
        this.getBuilders().put("drop-table", new DropTableBuilder());
        this.getBuilders().put("create-index", new CreateIndexBuilder());
    }

    public void visitComment(String theComment) throws SQLException {
        this.target.println(theComment);
    }

    public int visitStatement(String statement) throws SQLException {
        int found = 0;
        for (ExtractExpr theExpr : this.getDdlSpec().getExpressions()) {
            DDLScriptSqlMetaFactory.CatalogBuilder builder;
            Map values = this.getExtractor().extract(statement, theExpr);
            if (values == null) continue;
            ++found;
            if (log.isDebugEnabled()) {
                log.debug("FOUND " + theExpr.getName() + " in: " + statement);
                log.debug(String.valueOf(values));
            }
            if ((builder = this.getBuilders().get(theExpr.getName())) == null) break;
            this.target.println("\n-- from postgres: [ " + statement + ";]");
            try {
                builder.process(new MapNode(values), this.getCatalog());
            }
            catch (Exception e) {
                log.error("error processing " + values, (Throwable)e);
            }
            break;
        }
        if (found == 0) {
            this.target.println(statement + ";");
        }
        return 0;
    }

    public void doCommit() throws SQLException {
        this.target.println("COMMIT;");
    }

    public void doRollback() throws SQLException {
        this.target.println("ROLLBACK;");
    }

    protected class DropTableBuilder
    extends DDLScriptSqlMetaFactory.CatalogBuilder {
        protected DropTableBuilder() {
            super(ScriptTransformator.this);
        }

        public void process(MapNode values, CatalogDescription catalog) throws IOException, TemplateException {
            ScriptTransformator.this.templateEngine.putModel("table", values.getString("table"));
            ScriptTransformator.this.templateEngine.setTemplateName("drop-table.ftl");
            ScriptTransformator.this.templateEngine.generate(ScriptTransformator.this.target);
        }
    }

    protected class DropTriggerBuilder
    extends DDLScriptSqlMetaFactory.CatalogBuilder {
        protected DropTriggerBuilder() {
            super(ScriptTransformator.this);
        }

        public void process(MapNode values, CatalogDescription catalog) throws IOException, TemplateException {
            ScriptTransformator.this.templateEngine.putModel("trigger", values.getString("trigger"));
            ScriptTransformator.this.templateEngine.setTemplateName("drop-trigger.ftl");
            ScriptTransformator.this.templateEngine.generate(ScriptTransformator.this.target);
        }
    }

    protected class TableAlterColumnsBuilder
    extends DDLScriptSqlMetaFactory.CatalogBuilder {
        protected TableAlterColumnsBuilder() {
            super(ScriptTransformator.this);
        }

        public void process(MapNode values, CatalogDescription catalog) throws IOException, TemplateException {
            TableDescription td = this.getTable(catalog, values.getString("table"));
            List columns = values.getList("tableElement");
            ScriptTransformator.this.templateEngine.putModel("table", td);
            int idx = 0;
            for (Object column : columns) {
                Map map;
                if (idx > 0) {
                    ScriptTransformator.this.target.println(",");
                }
                if ((map = (Map)column).containsKey("add-column")) {
                    this.genAddColumn(map, td);
                    continue;
                }
                if (map.containsKey("alter-column-type")) {
                    this.genAlterColumnType(map);
                    continue;
                }
                if (map.containsKey("alter-column-drop-notnull")) {
                    this.genColumnDropNotNull(map);
                    continue;
                }
                if (map.containsKey("alter-column-set-notnull")) {
                    this.genColumnSetNotNull(map);
                    continue;
                }
                if (map.containsKey("constraint")) {
                    this.genAddConstraint(map, values);
                    continue;
                }
                if (map.containsKey("add-foreign-key")) {
                    this.genAddForeignKey(map, values);
                    continue;
                }
                if (map.containsKey("drop-column")) {
                    this.genDropColumn(map);
                    continue;
                }
                if (!map.containsKey("drop-constraint")) continue;
                this.genDropConstraint(map);
            }
        }

        private void genDropConstraint(Map map) throws IOException, TemplateException {
            MapNode node = new MapNode((Map)map.get("drop-constraint"));
            String colName = node.getString("constraintName");
            ScriptTransformator.this.templateEngine.setTemplateName("alter-table-drop-constraint.ftl");
            ScriptTransformator.this.templateEngine.putModel("constraintName", colName);
            ScriptTransformator.this.templateEngine.generate(ScriptTransformator.this.target);
        }

        private void genDropColumn(Map map) throws IOException, TemplateException {
            MapNode node = new MapNode((Map)map.get("drop-column"));
            String colName = node.getString("column");
            ScriptTransformator.this.templateEngine.setTemplateName("alter-table-drop-column.ftl");
            ScriptTransformator.this.templateEngine.putModel("columnName", colName);
            ScriptTransformator.this.templateEngine.generate(ScriptTransformator.this.target);
        }

        private void genAddForeignKey(Map map, MapNode values) throws IOException, TemplateException {
            MapNode node = new MapNode((Map)map.get("add-foreign-key"));
            ForeignKeyDescription fk = new ForeignKeyDescription();
            fk.setConstraintName(this.strip(node.getString("constraintName")));
            fk.setOnDeleteRule(this.strip(node.getString("onDeleteRule")));
            fk.setRefTableName(this.strip(node.getString("refTable")));
            fk.setTableName(this.strip(values.getString("table")));
            fk.setTableSpace(this.strip(node.getString("tableSpace/tableSpace")));
            List icols = node.getList("columns");
            List rcols = node.getList("refcolumns");
            int i = 0;
            for (Object icol : icols) {
                Map eachCol = (Map)icol;
                Map rcol = (Map)rcols.get(i++);
                fk.addColumnPair(this.strip((String)eachCol.get("column")), this.strip((String)rcol.get("column")));
            }
            ScriptTransformator.this.templateEngine.setTemplateName("alter-table-add-foreignkey.ftl");
            ForeignKeyDescription newFk = fk.deepCopy();
            ScriptTransformator.this.catalogConversion.transformForeignKey(newFk, fk);
            ScriptTransformator.this.templateEngine.putModel("foreignKey", newFk);
            ScriptTransformator.this.templateEngine.generate(ScriptTransformator.this.target);
        }

        private void genAddConstraint(Map map, MapNode values) throws IOException, TemplateException {
            MapNode node = new MapNode((Map)map.get("constraint"));
            IndexDescription id = new IndexDescription();
            id.setTableName(this.strip(values.getString("table")));
            id.setTableSpace(this.strip(node.getString("tableSpace/tableSpace")));
            id.setIndexName(this.strip(node.getString("constraintName")));
            id.setUnique(this.getBool(node, "unique"));
            List icols = node.getList("columns");
            for (Object icol : icols) {
                Map eachCol = (Map)icol;
                id.addColumn(this.strip((String)eachCol.get("column")));
            }
            ScriptTransformator.this.templateEngine.setTemplateName("alter-table-add-constraint.ftl");
            ScriptTransformator.this.templateEngine.putModel("index", id);
            ScriptTransformator.this.templateEngine.generate(ScriptTransformator.this.target);
        }

        private void genColumnSetNotNull(Map map) throws IOException, TemplateException {
            MapNode node = new MapNode((Map)map.get("alter-column-set-notnull"));
            String colName = node.getString("column");
            ScriptTransformator.this.templateEngine.setTemplateName("alter-table-set-notnull.ftl");
            ScriptTransformator.this.templateEngine.putModel("columnName", colName);
            ScriptTransformator.this.templateEngine.generate(ScriptTransformator.this.target);
        }

        private void genColumnDropNotNull(Map map) throws IOException, TemplateException {
            MapNode node = new MapNode((Map)map.get("alter-column-drop-notnull"));
            String colName = node.getString("column");
            ScriptTransformator.this.templateEngine.setTemplateName("alter-table-drop-notnull.ftl");
            ScriptTransformator.this.templateEngine.putModel("columnName", colName);
            ScriptTransformator.this.templateEngine.generate(ScriptTransformator.this.target);
        }

        private void genAlterColumnType(Map map) throws IOException, TemplateException {
            MapNode node = new MapNode((Map)map.get("alter-column-type"));
            String colName = node.getString("column");
            ColumnDescription colDef = new ColumnDescription();
            colDef.setNullable(true);
            colDef.setColumnName(colName);
            this.setColType(node, colDef);
            ColumnDescription newColDef = colDef.deepCopy();
            ScriptTransformator.this.catalogConversion.transformColumn(newColDef, colDef);
            ScriptTransformator.this.templateEngine.putModel("column", newColDef);
            ScriptTransformator.this.templateEngine.setTemplateName("alter-table-modify-column.ftl");
            ScriptTransformator.this.templateEngine.generate(ScriptTransformator.this.target);
        }

        private void genAddColumn(Map map, TableDescription td) throws IOException, TemplateException {
            ColumnDescription colDef = this.buildColumnDescription(new MapNode((Map)map.get("add-column")), td);
            ColumnDescription newColDef = colDef.deepCopy();
            ScriptTransformator.this.catalogConversion.transformColumn(newColDef, colDef);
            ScriptTransformator.this.templateEngine.putModel("column", newColDef);
            ScriptTransformator.this.templateEngine.setTemplateName("alter-table-add-column.ftl");
            ScriptTransformator.this.templateEngine.generate(ScriptTransformator.this.target);
        }
    }

    protected class CreateIndexBuilder
    extends DDLScriptSqlMetaFactory.CatalogBuilder {
        protected CreateIndexBuilder() {
            super(ScriptTransformator.this);
        }

        public void process(MapNode map, CatalogDescription catalog) throws IOException, TemplateException {
            IndexDescription index = new IndexDescription();
            index.setIndexName(this.strip(map.getString("indexName")));
            List cols = map.getList("columns");
            for (Map col : cols) {
                index.addColumn((String)col.get("column"), (String)col.get("desc"));
            }
            index.setTableName(this.strip(map.getString("table")));
            index.setTableSpace(this.strip(map.getString("tableSpace")));
            index.setUnique("UNIQUE".equalsIgnoreCase(map.getString("unique")));
            ScriptTransformator.this.templateEngine.putModel("index", index);
            ScriptTransformator.this.templateEngine.setTemplateName("create-index.ftl");
            ScriptTransformator.this.templateEngine.generate(ScriptTransformator.this.target);
        }
    }

    protected class TransformDezignCreateTableBuilder
    extends DDLScriptSqlMetaFactory.DezignCreateTableBuilder {
        protected TransformDezignCreateTableBuilder() {
            super(ScriptTransformator.this);
        }

        public void process(MapNode values, CatalogDescription catalog) throws IOException, TemplateException {
            super.process(values, catalog);
            String tableName = this.strip(values.getString("table"));
            TableDescription td = this.getTable(catalog, tableName);
            TableDescription newTd = td.deepCopy();
            ScriptTransformator.this.catalogConversion.transformTable(newTd, td);
            ScriptTransformator.this.templateEngine.putModel("table", newTd);
            ScriptTransformator.this.templateEngine.setTemplateName("create-table.ftl");
            ScriptTransformator.this.templateEngine.generate(ScriptTransformator.this.target);
        }
    }
}

