/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate.util;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class DBVersionMeta
implements Serializable {
    private String tableName = "DB_VERSION";
    private String column_version = "version";
    private String column_since = "since";
    private boolean insertOnly = false;
    private boolean autoCreate = true;
    private boolean autoVersion = false;
    private LockBusy lockBusy = LockBusy.No;
    private String sqlInsert;
    private String sqlSelect;
    private String sqlUpdate;
    private String sqlDelete;

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public boolean isAutoVersion() {
        return this.autoVersion;
    }

    public void setAutoVersion(boolean autoVersion) {
        this.autoVersion = autoVersion;
    }

    public LockBusy getLockBusy() {
        return this.lockBusy;
    }

    public void setLockBusy(LockBusy lockBusy) {
        this.lockBusy = lockBusy;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        this.resetCache();
    }

    public String getColumn_version() {
        return this.column_version;
    }

    public void setColumn_version(String column_version) {
        this.column_version = column_version;
        this.resetCache();
    }

    protected void resetCache() {
        this.sqlInsert = null;
        this.sqlSelect = null;
        this.sqlUpdate = null;
        this.sqlDelete = null;
    }

    public String getColumn_since() {
        return this.column_since;
    }

    public void setColumn_since(String column_since) {
        this.column_since = column_since;
        this.resetCache();
    }

    public String getQualifiedVersionColumn() {
        return this.tableName + "." + this.column_version;
    }

    public String toSQLInsert() {
        if (this.sqlInsert == null) {
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO ");
            sql.append(this.getTableName());
            sql.append("(").append(this.getColumn_version());
            if (StringUtils.isNotEmpty((String)this.getColumn_since())) {
                sql.append(", ");
                sql.append(this.getColumn_since());
            }
            sql.append(") VALUES(?");
            if (StringUtils.isNotEmpty((String)this.getColumn_since())) {
                sql.append(",?");
            }
            sql.append(")");
            this.sqlInsert = sql.toString();
        }
        return this.sqlInsert;
    }

    public String toSQLUpdate() {
        if (this.sqlUpdate == null) {
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE ");
            sql.append(this.getTableName());
            sql.append(" SET ");
            sql.append(this.getColumn_version());
            sql.append("=?");
            if (StringUtils.isNotEmpty((String)this.getColumn_since())) {
                sql.append(", ");
                sql.append(this.getColumn_since());
                sql.append("=?");
            }
            this.sqlUpdate = sql.toString();
        }
        return this.sqlUpdate;
    }

    public String toSQLDelete() {
        if (this.sqlDelete == null) {
            StringBuilder sql = new StringBuilder();
            sql.append("DELETE FROM ");
            sql.append(this.getTableName());
            sql.append(" WHERE ");
            sql.append(this.getColumn_version());
            sql.append("=?");
            this.sqlDelete = sql.toString();
        }
        return this.sqlDelete;
    }

    public String toSQLCreateTable() {
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE ").append(this.getTableName()).append(" (");
        if (StringUtils.isNotEmpty((String)this.getColumn_since())) {
            buf.append(this.getColumn_since()).append(" TIMESTAMP, ");
        }
        buf.append(this.getColumn_version()).append(" VARCHAR(100) NOT NULL)");
        return buf.toString();
    }

    public String toSQLSelectVersion() {
        if (this.sqlSelect == null) {
            this.sqlSelect = "SELECT " + this.getColumn_version() + " FROM " + this.getTableName();
            if (StringUtils.isNotEmpty((String)this.getColumn_since())) {
                this.sqlSelect = this.sqlSelect + " ORDER BY " + this.getColumn_since() + " DESC";
            }
        }
        return this.sqlSelect;
    }

    public String toSQLCountVersion() {
        if (this.sqlSelect == null) {
            this.sqlSelect = "SELECT COUNT(*) FROM " + this.getTableName() + " WHERE " + this.getColumn_version() + "=?";
        }
        return this.sqlSelect;
    }

    public String toSQLLockAll() {
        if (this.sqlSelect == null) {
            this.sqlSelect = "UPDATE " + this.getTableName() + " SET " + this.getColumn_version() + "=" + this.getColumn_version();
        }
        return this.sqlSelect;
    }

    public void setInsertOnly(boolean aBoolean) {
        this.insertOnly = aBoolean;
    }

    public boolean isInsertOnly() {
        return this.insertOnly;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LockBusy {
        No,
        Wait,
        Fail;

    }
}

