/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class AliasDictionary {
    public static final String ALIAS_RESERVATION = "@";
    private List<String[]> aliases = new ArrayList<String[]>();
    private String hiddenAlias = null;

    public void setHiddenAlias(String ha) {
        this.hiddenAlias = ha;
    }

    public String getHiddenAlias() {
        return this.hiddenAlias;
    }

    public void clear() {
        this.aliases.clear();
    }

    public void appendAliasListTo(Writer stream) throws IOException {
        boolean hadEffect = this.hiddenAlias != null;
        for (String[] aliase : this.aliases) {
            String table = aliase[1];
            if (aliase[0].equals(this.hiddenAlias) || table.equals(ALIAS_RESERVATION)) continue;
            if (hadEffect) {
                stream.write(", ");
            }
            hadEffect = true;
            stream.write(table);
            if (aliase[2].length() > 0) {
                stream.write(aliase[2]);
            }
            if (aliase[0].length() <= 0) continue;
            stream.write(32);
            stream.write(aliase[0]);
        }
    }

    public int size() {
        return this.aliases.size();
    }

    public String findAlias(String tableName) {
        for (String[] aliase : this.aliases) {
            if (!aliase[1].equalsIgnoreCase(tableName)) continue;
            return aliase[0];
        }
        return null;
    }

    public String removeAlias(String alias) {
        for (int i = this.aliases.size() - 1; i >= 0; --i) {
            String[] entry = this.aliases.get(i);
            if (!alias.equals(entry[0])) continue;
            this.aliases.remove(i);
            return entry[1];
        }
        return null;
    }

    public void setAlias(String tableName, String alias) {
        this.setAlias(tableName, alias, null);
    }

    public void setAlias(String aTableName, String aALias, String aDBLink) {
        if (aALias == null) {
            aALias = "";
        }
        if (aDBLink == null) {
            aDBLink = "";
        }
        for (int i = this.aliases.size() - 1; i >= 0; --i) {
            String[] entry = this.aliases.get(i);
            if (!entry[0].equals(aALias)) continue;
            entry[1] = aTableName;
            entry[2] = aDBLink;
            return;
        }
        this.aliases.add(new String[]{aALias, aTableName, aDBLink});
    }

    public String toString() {
        return this.aliases.toString();
    }
}

