/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.postgres;

import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.checking.DatabaseSchemaChecker;
import com.agimatec.sql.meta.postgres.PostgresJdbcSqlMetaFactory;
import com.agimatec.sql.meta.script.DDLExpressions;
import com.agimatec.sql.meta.script.DDLScriptSqlMetaFactory;
import java.io.IOException;
import java.sql.SQLException;

public class PostgresSchemaChecker
extends DatabaseSchemaChecker {
    public void assertObjectsValid() throws Exception {
    }

    protected DDLScriptSqlMetaFactory getDDLScriptSqlMetaFactory() {
        return new DDLScriptSqlMetaFactory(DDLExpressions.forDbms("postgres"));
    }

    protected CatalogDescription readDatabaseCatalog(String[] tableNames) throws SQLException, IOException {
        PostgresJdbcSqlMetaFactory factory = new PostgresJdbcSqlMetaFactory(this.getDatabase());
        return factory.buildCatalog(tableNames);
    }

    protected boolean isTypeCompatible(ColumnDescription expected, ColumnDescription actual) {
        boolean valid = super.isTypeCompatible(expected, actual);
        if (valid) {
            return valid;
        }
        return this.equalizeType(expected).equalsIgnoreCase(this.equalizeType(actual));
    }

    private String equalizeType(ColumnDescription cd) {
        if (cd.getTypeName().equalsIgnoreCase("float8")) {
            return "FLOAT";
        }
        if (cd.getTypeName().equalsIgnoreCase("numeric")) {
            return "DECIMAL";
        }
        if (cd.getTypeName().equalsIgnoreCase("int8")) {
            return "BIGINT";
        }
        if (cd.getTypeName().equalsIgnoreCase("int4")) {
            return "INTEGER";
        }
        if (cd.getTypeName().equalsIgnoreCase("int2")) {
            return "SMALLINT";
        }
        if (cd.getTypeName().equalsIgnoreCase("bpchar")) {
            return "CHARACTER";
        }
        if (cd.getTypeName().equalsIgnoreCase("BOOL")) {
            return "BOOLEAN";
        }
        if (cd.getTypeName().equalsIgnoreCase("CHARACTER VARYING")) {
            return "VARCHAR";
        }
        return cd.getTypeName();
    }
}

