/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate.util;

import com.agimatec.dbmigrate.HaltedException;
import com.agimatec.dbmigrate.util.DBVersionMeta;
import com.agimatec.dbmigrate.util.DatabaseLocker;
import com.agimatec.dbmigrate.util.SQLCursor;
import com.agimatec.dbmigrate.util.UpdateVersionScriptVisitor;
import com.agimatec.jdbc.JdbcDatabase;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusyLocker
implements DatabaseLocker {
    protected final String BUSY_VERSION = "busy";
    protected static final Logger log = LoggerFactory.getLogger(BusyLocker.class);
    private final DBVersionMeta lockMeta;
    private int maxAttempts = -1;
    private int delayBetweenAttempts = 10000;
    protected boolean ownLock = false;

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public int getDelayBetweenAttempts() {
        return this.delayBetweenAttempts;
    }

    public void setDelayBetweenAttempts(int delayBetweenAttempts) {
        this.delayBetweenAttempts = delayBetweenAttempts;
    }

    public BusyLocker(DBVersionMeta dbVersionMeta) {
        this.lockMeta = this.createLockMeta(dbVersionMeta);
    }

    public boolean isEnabled() {
        return this.lockMeta.getLockBusy() != null && this.lockMeta.getLockBusy() != DBVersionMeta.LockBusy.No;
    }

    public void lock(JdbcDatabase database) {
        block4: {
            if (this.lockMeta.getLockBusy() == DBVersionMeta.LockBusy.No) {
                return;
            }
            DBVersionMeta lockMeta = this.createLockMeta(this.lockMeta);
            try {
                this.tryLock(database);
            }
            catch (SQLException ex) {
                if (lockMeta.getLockBusy() == DBVersionMeta.LockBusy.Fail) {
                    this.fail(ex);
                }
                if (lockMeta.getLockBusy() != DBVersionMeta.LockBusy.Wait) break block4;
                this.waitAndRetry(database, 1, ex);
            }
        }
    }

    public DBVersionMeta getLockMeta() {
        return this.lockMeta;
    }

    protected DBVersionMeta createLockMeta(DBVersionMeta dbVersionMeta) {
        DBVersionMeta lockMeta = dbVersionMeta.copy();
        lockMeta.setInsertOnly(false);
        lockMeta.setTableName(lockMeta.getLockTableName());
        return lockMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryLock(JdbcDatabase database) throws SQLException {
        Statement stmt = database.getConnection().createStatement();
        SQLCursor cursor = null;
        try {
            cursor = new SQLCursor(stmt, stmt.executeQuery(this.lockMeta.toSQLSelectVersion()));
            cursor.next();
            cursor.close();
        }
        catch (SQLException ex) {
            if (cursor != null) {
                cursor.close();
            }
            log.warn("Cannot access " + this.lockMeta.getTableName() + ": " + ex.getMessage());
            try {
                UpdateVersionScriptVisitor.createTable(database, this.lockMeta);
            }
            catch (SQLException ex2) {
                log.warn("Read exception was: ", (Throwable)ex);
                log.warn("Cannot create " + this.lockMeta.getTableName() + " write exception was: ", (Throwable)ex2);
                throw ex2;
            }
        }
        finally {
            stmt.close();
        }
        int count = UpdateVersionScriptVisitor.insertVersion(database, "busy", this.lockMeta);
        if (count != 1) {
            log.warn(this.lockMeta.toSQLInsert() + " for busy-lock '" + "busy" + "' affected " + count + " rows!");
        } else {
            log.info("Aquired busy-lock 'busy' on table " + this.lockMeta.getTableName());
            this.setOwnLock(true);
        }
    }

    public boolean isOwnLock() {
        return this.ownLock;
    }

    public void setOwnLock(boolean ownLock) {
        this.ownLock = ownLock;
    }

    private void fail(SQLException ex) {
        throw new HaltedException("Could not aquire busy-lock 'busy' from table '" + this.lockMeta.getLockTableName() + "'. " + "Perhaps another instance of dbmigrate is currently running on the database or " + "the lock was not correctly removed from a previous execution of dbmigrate. " + "\nTo remove the lock, execute: " + "DELETE FROM " + this.lockMeta.getTableName() + " WHERE " + this.lockMeta.getColumn_version() + " = '" + "busy" + "';", ex);
    }

    private void waitAndRetry(JdbcDatabase database, int attempt, SQLException ex) {
        while (this.maxAttempts < 0 || attempt < this.maxAttempts) {
            log.warn("Attempt " + attempt + " to aquire busy-lock failed. Waiting for " + this.delayBetweenAttempts + " millis to retry...", (Throwable)ex);
            if (this.delayBetweenAttempts > 0) {
                try {
                    Thread.sleep(this.delayBetweenAttempts);
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while waiting for retry", (Throwable)e);
                }
            }
            try {
                this.tryLock(database);
                return;
            }
            catch (SQLException e) {
                ex = e;
                ++attempt;
            }
        }
        this.fail(ex);
    }

    public void unlock(JdbcDatabase database) {
        if (this.lockMeta.getLockBusy() == DBVersionMeta.LockBusy.No) {
            return;
        }
        if (!this.isOwnLock()) {
            log.info("Not deleting lock 'busy' on table " + this.lockMeta.getTableName() + " because this instance does not own it.");
        } else {
            try {
                int count = UpdateVersionScriptVisitor.deleteVersion(database, "busy", this.lockMeta);
                if (count != 1) {
                    log.warn(this.lockMeta.toSQLDelete() + " for busy-lock '" + "busy" + "' affected " + count + " rows!");
                } else {
                    log.info("Deleted busy-lock 'busy' on table " + this.lockMeta.getTableName());
                    this.setOwnLock(false);
                }
            }
            catch (SQLException e) {
                log.error("Failed to delete busy-lock", (Throwable)e);
            }
        }
    }
}

