/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate.util;

import com.agimatec.commons.beans.MapQuery;
import com.agimatec.dbmigrate.util.ScriptVisitorDelegate;
import com.agimatec.sql.script.ScriptVisitor;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConditionalScriptVisitor
extends ScriptVisitorDelegate {
    private static final Logger log = LoggerFactory.getLogger(ConditionalScriptVisitor.class);
    private Map environment = Collections.EMPTY_MAP;
    private Stack conditionStack = new Stack();
    private Stack expressionStack = new Stack();

    public ConditionalScriptVisitor(ScriptVisitor aVisitor, Map env) {
        super(aVisitor);
        this.environment = env;
    }

    public ConditionalScriptVisitor(ScriptVisitor aVisitor) {
        super(aVisitor);
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map aEnvironment) {
        this.environment = aEnvironment;
    }

    public void visitComment(String theComment) throws SQLException {
        super.visitComment(theComment);
        int idx = theComment.indexOf("#if ");
        if (idx >= 0) {
            String condition = theComment.substring(idx + 4);
            MapQuery q = new MapQuery(condition);
            this.expressionStack.push(condition);
            this.conditionStack.push(q.doesMatch(this.getEnvironment()));
            log.info("FOUND Condition: (" + q.toString() + ") = " + this.conditionStack.peek());
        } else if (theComment.indexOf("#endif") >= 0) {
            if (this.expressionStack.isEmpty()) {
                log.error(theComment + " ---> #endif without #if!");
            } else {
                log.info("END of Condition: (" + this.expressionStack.peek() + ")");
                this.conditionStack.pop();
                this.expressionStack.pop();
            }
        }
    }

    public boolean isConditionTrue() {
        if (this.conditionStack.isEmpty()) {
            return true;
        }
        for (Object aConditionStack : this.conditionStack) {
            Boolean bool = (Boolean)aConditionStack;
            if (bool.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public void doCommit() throws SQLException {
        if (this.isConditionTrue()) {
            super.doCommit();
        } else if (log.isInfoEnabled()) {
            log.info("commit - ignored because: " + this.conditionCause());
        }
    }

    private String conditionCause() {
        return this.expressionStack.peek() + " --> " + this.conditionStack.peek();
    }

    public void doRollback() throws SQLException {
        if (this.isConditionTrue()) {
            super.doRollback();
        } else if (log.isInfoEnabled()) {
            log.info("rollback - ignored because:" + this.conditionCause());
        }
    }

    public int visitStatement(String statement) throws SQLException {
        if (this.isConditionTrue()) {
            return super.visitStatement(statement);
        }
        if (log.isInfoEnabled()) {
            log.info("statement: '" + statement + "' - ignored because: " + this.conditionCause());
        }
        return 0;
    }
}

