/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbtransform.ejb3;

import com.agimatec.dbtransform.ejb3.Ejb3Attribute;
import com.agimatec.dbtransform.ejb3.Ejb3Prototype;
import com.agimatec.dbtransform.ejb3.Ejb3Relationship;
import com.agimatec.dbtransform.ejb3.Ejb3RelationshipManyToMany;
import com.agimatec.dbtransform.ejb3.Ejb3RelationshipOneToMany;
import com.agimatec.dbtransform.ejb3.Ejb3Schema;
import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.ForeignKeyDescription;
import com.agimatec.sql.meta.IndexDescription;
import com.agimatec.sql.meta.TableDescription;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3Class
extends Ejb3Prototype {
    private static final Logger log = LoggerFactory.getLogger(Ejb3Class.class);
    private final TableDescription table;
    private final List<Ejb3Attribute> attributes = new ArrayList<Ejb3Attribute>();
    private final List<Ejb3Relationship> relationships = new ArrayList<Ejb3Relationship>();
    private final String className;

    public Ejb3Class(TableDescription tableDescription) {
        this.table = tableDescription;
        this.className = this.toProperEntityName(this.table.getTableName().toLowerCase());
    }

    protected Ejb3Class(String name) {
        this.table = null;
        this.className = this.toProperEntityName(name);
    }

    public TableDescription getTable() {
        return this.table;
    }

    public String getClassName() {
        return this.className;
    }

    public void generateAttributes() {
        for (ColumnDescription column : this.table.getColumns()) {
            if (this.table.isForeignKeyColumn(column.getColumnName())) continue;
            Ejb3Attribute attribute = new Ejb3Attribute(column);
            attribute.generate();
            this.attributes.add(attribute);
        }
    }

    public List<List<String>> getMultiUniqueConstraints() {
        ArrayList<List<String>> uniqueCons = new ArrayList<List<String>>();
        for (IndexDescription index : this.table.getConstraints()) {
            if (!index.isUnique() || index.getColumnSize() <= 1) continue;
            uniqueCons.add(index.getColumns());
        }
        for (IndexDescription index : this.table.getIndices()) {
            if (!index.isUnique() || index.getColumnSize() <= 1 || uniqueCons.contains(index.getColumns())) continue;
            uniqueCons.add(index.getColumns());
        }
        return uniqueCons;
    }

    public void generateRelationships(Ejb3Schema ejb3Schema) {
        if (this.isManyToManyLink()) {
            Ejb3RelationshipManyToMany relationship = new Ejb3RelationshipManyToMany(this.table.getForeignKey(0), this.table.getForeignKey(1));
            relationship.setOptional(false);
            relationship.generate(ejb3Schema);
            Ejb3Class ejb3Class = ejb3Schema.getEjb3classes().get(relationship.getForeignKey().getRefTableName());
            ejb3Class.getRelationships().add(relationship);
        } else {
            for (ForeignKeyDescription fk : this.table.getForeignKeys()) {
                Ejb3Relationship relationship = new Ejb3Relationship(fk);
                relationship.generate(ejb3Schema);
                this.relationships.add(relationship);
                Ejb3Class ejb3Class = ejb3Schema.getEjb3classes().get(fk.getRefTableName());
                if (ejb3Class != null) {
                    Ejb3RelationshipOneToMany otherSide = new Ejb3RelationshipOneToMany(fk);
                    if (relationship.isOneToOne()) {
                        otherSide.setOneToOne(true);
                    }
                    otherSide.setMappedByRelationship(relationship);
                    otherSide.generate(ejb3Schema);
                    ejb3Class.getRelationships().add(otherSide);
                    continue;
                }
                log.warn("cannot find referenced class for table " + fk.getRefTableName() + " at foreign key " + fk);
            }
        }
    }

    public List<Ejb3Attribute> getAttributes() {
        return this.attributes;
    }

    public List<Ejb3Relationship> getRelationships() {
        return this.relationships;
    }

    public String toString() {
        return this.className;
    }

    public boolean isManyToManyLink() {
        if (this.table.getColumnSize() != 2) {
            return false;
        }
        for (ColumnDescription column : this.table.getColumns()) {
            if (!this.table.isForeignKeyColumn(column.getColumnName())) {
                return false;
            }
            if (this.table.isPrimaryKeyColumn(column.getColumnName())) continue;
            return false;
        }
        return true;
    }
}

