/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.script;

import com.agimatec.commons.config.ConfigManager;
import com.agimatec.commons.util.ClassUtils;
import com.agimatec.commons.util.PropertyReplacer;
import com.agimatec.jdbc.JdbcException;
import com.agimatec.sql.script.ScriptVisitor;
import com.agimatec.sql.script.WordTokenizer;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLScriptParser {
    private static final Logger myClassLogger = LoggerFactory.getLogger(SQLScriptParser.class);
    private Logger myLog = myClassLogger;
    private boolean myFailOnError = false;
    private final String myScriptRoot;
    private PropertyReplacer myEnvReplacer = null;
    private static final String COMMENT_LINE = "--";
    private static final String COMMENT_MULTILINE_BEGIN = "/*";
    private static final String COMMENT_MULTILINE_END = "*/";
    private static final String LITERAL = "'";
    private static final String SEMICOLON = ";";
    private static final String SLASH = "/";
    private static final String[] PROCEDURE_OR_TRIGGER = new String[]{"begin", "declare", "cursor"};
    private static final String[] SQL_SEPARATORS;
    private static final String[] PROCEDURE_SEPARATORS;

    public SQLScriptParser(String aScriptRoot, Logger aLog) {
        this.myLog = aLog;
        this.myScriptRoot = aScriptRoot;
    }

    public SQLScriptParser(Logger aLog) {
        this.myScriptRoot = null;
        this.myLog = aLog;
    }

    public void useLogger(Logger aLogger) {
        this.myLog = aLogger;
    }

    public void setFailOnError(boolean aFailOnError) {
        this.myFailOnError = aFailOnError;
    }

    protected void handleAffectedRow(int affectedRows, String command) {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(affectedRows + " rows affected");
        }
    }

    protected void handleError(SQLException ex, String command) throws SQLException {
        this.getLog().error("SQL-EXCEPTION: " + ex.getMessage());
        if (this.myFailOnError) {
            throw ex;
        }
    }

    protected void handleError(JdbcException ex, String command) throws JdbcException {
        this.getLog().error("JDBC-EXCEPTION: " + ex.getMessage());
        if (this.myFailOnError) {
            throw ex;
        }
    }

    protected Logger getLog() {
        return this.myLog;
    }

    public void setEnvironment(Map aEnv) {
        this.myEnvReplacer = aEnv == null ? null : new PropertyReplacer(aEnv);
    }

    protected String getScriptDir() {
        return this.myScriptRoot;
    }

    protected String fixLF(String aStatement) {
        int t = aStatement.lastIndexOf(47);
        int idx = aStatement.lastIndexOf(59);
        if (idx > 0 && t > idx) {
            aStatement = aStatement.substring(0, idx + 1);
        }
        return aStatement.replace("\r\n", "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateSQLScript(ScriptVisitor visitor, String scriptName) throws SQLException, IOException {
        Object[] readerPath = this.openReaderPath(scriptName);
        Reader input = (Reader)readerPath[0];
        String path = (String)readerPath[1];
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info("Parsing " + path + " ... ");
        }
        try {
            this.iterateSQL(visitor, input);
        }
        finally {
            input.close();
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("DONE with " + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateSQLLines(ScriptVisitor visitor, String scriptName) throws SQLException, IOException {
        Object[] readerPath = this.openReaderPath(scriptName);
        BufferedReader input = (BufferedReader)readerPath[0];
        String path = (String)readerPath[1];
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info("Executing line by line " + path + " ... ");
        }
        try {
            this.iterateSQLLines(visitor, input);
        }
        finally {
            input.close();
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("DONE with " + path);
        }
    }

    private void iterateSQLLines(ScriptVisitor visitor, BufferedReader input) throws IOException, SQLException {
        ParseState parseState = new ParseState(visitor);
        String statement = input.readLine();
        while (statement != null) {
            if ((statement = this.finish(statement)).startsWith(COMMENT_LINE)) {
                visitor.visitComment(statement);
            } else {
                parseState.appendSql(statement);
                parseState.visitSql();
            }
            statement = input.readLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateSQLLines(ScriptVisitor visitor, URL url) throws SQLException, IOException {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info("Executing line by line " + url + " ... ");
        }
        BufferedReader input = SQLScriptParser.getURLReader(url);
        try {
            this.iterateSQLLines(visitor, input);
        }
        finally {
            input.close();
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("DONE with " + url);
        }
    }

    public void execSQLScript(ScriptVisitor visitor, String scriptName) throws IOException, SQLException {
        Object[] readerPath = this.openReaderPath(scriptName);
        Reader input = (Reader)readerPath[0];
        String path = (String)readerPath[1];
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info("Reading and executing " + path + " ... ");
        }
        String statement = IOUtils.toString((Reader)input);
        statement = this.finish(statement);
        statement = this.fixLF(statement);
        ParseState parseState = new ParseState(visitor);
        parseState.appendSql(statement);
        parseState.visitSql();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("DONE with " + path);
        }
    }

    public void execSQLScript(ScriptVisitor visitor, URL url) throws IOException, SQLException {
        BufferedReader input = SQLScriptParser.getURLReader(url);
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info("Reading and executing " + url + " ... ");
        }
        String statement = IOUtils.toString((Reader)input);
        statement = this.finish(statement);
        statement = this.fixLF(statement);
        ParseState parseState = new ParseState(visitor);
        parseState.appendSql(statement);
        parseState.visitSql();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("DONE with " + url);
        }
    }

    protected Object[] openReaderPath(String scriptName) throws IOException {
        BufferedReader input;
        String path;
        if (scriptName.startsWith("cp://")) {
            URL ress = ClassUtils.getClassLoader().getResource(scriptName.substring(5));
            path = ress.toExternalForm();
            input = new BufferedReader(new InputStreamReader(ress.openStream()));
        } else {
            path = this.getScriptDir() != null ? this.getScriptDir() + scriptName : scriptName;
            URL ress = ConfigManager.toURL(path);
            if (ress == null) {
                throw new FileNotFoundException(path);
            }
            input = new BufferedReader(new InputStreamReader(ress.openStream()));
        }
        return new Object[]{input, path};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateSQLScript(ScriptVisitor visitor, URL url) throws SQLException, IOException {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info("Parsing " + url + " ... ");
        }
        BufferedReader input = SQLScriptParser.getURLReader(url);
        try {
            this.iterateSQL(visitor, input);
        }
        finally {
            ((Reader)input).close();
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("DONE with " + url);
        }
    }

    public static BufferedReader getURLReader(URL url) throws IOException {
        InputStream fs = url.openStream();
        return new BufferedReader(new InputStreamReader(fs));
    }

    public void iterateSQL(ScriptVisitor visitor, String aSqls) throws SQLException, IOException {
        StringReader input = new StringReader(aSqls);
        this.iterateSQL(visitor, input);
    }

    public void iterateSQL(ScriptVisitor visitor, Reader input) throws SQLException, IOException {
        this.parseSQL(new ParseState(visitor), input);
    }

    private void parseSQL(ParseState state, Reader input) throws IOException, SQLException {
        WordTokenizer tokens = new WordTokenizer(input, SQL_SEPARATORS, true, false);
        String token = tokens.nextToken();
        int procMode = 1;
        while (token != null) {
            if (LITERAL.equals(token)) {
                procMode = 0;
                state.appendSql(token);
                tokens.addChar(this.parseLiteral(state, tokens));
            } else if (COMMENT_LINE.equals(token)) {
                this.parseCommentLine(state, tokens);
            } else if (COMMENT_MULTILINE_BEGIN.equals(token)) {
                this.parseCommentMultiLine(state, tokens);
            } else if ("\n".equals(token) || "\r".equals(token)) {
                state.needsBlank = true;
                if (state.isSlashLine()) {
                    state.visitSql();
                }
                state.newLine();
                if (procMode == 2) {
                    if ("\n".equals(token)) {
                        state.appendPlain(token);
                    }
                    this.detectProcedure(state, tokens);
                }
                procMode = 1;
            } else if (SEMICOLON.equals(token)) {
                if (procMode == 2) {
                    this.detectProcedure(state, tokens);
                }
                state.visitSql();
                procMode = 1;
            } else if (ArrayUtils.indexOf((Object[])PROCEDURE_OR_TRIGGER, (Object)token.toLowerCase(), (int)0) >= 0) {
                state.appendCurrentSql(token);
                procMode = procMode == 1 ? 2 : 0;
            } else if (" ".equals(token) || "\t".equals(token)) {
                state.appendPlain(" ");
                if (procMode == 2) {
                    this.detectProcedure(state, tokens);
                }
                procMode = 1;
            } else {
                procMode = 0;
                if (token.trim().length() > 0) {
                    state.appendCurrentSql(token);
                }
            }
            token = tokens.nextToken();
        }
        if (!state.isEmpty()) {
            state.visitSql();
        }
    }

    private void detectProcedure(ParseState state, WordTokenizer tokens) throws SQLException, IOException {
        this.parseProcedure(state, tokens);
        tokens.setSeparators(SQL_SEPARATORS);
    }

    private void parseProcedure(ParseState state, WordTokenizer tokens) throws IOException, SQLException {
        tokens.setSeparators(PROCEDURE_SEPARATORS);
        String token = tokens.nextToken();
        while (token != null) {
            if ("\r".equals(token)) {
                if (state.procNewLine()) {
                    return;
                }
            } else if ("\n".equals(token)) {
                state.appendSql("\n");
                if (state.procNewLine()) {
                    return;
                }
            } else {
                state.appendCurrentSql(token);
            }
            token = tokens.nextToken();
        }
    }

    private void parseCommentMultiLine(ParseState state, WordTokenizer parent) throws IOException, SQLException {
        WordTokenizer tokens = new WordTokenizer(parent, new String[]{COMMENT_MULTILINE_END}, false, true);
        state.visitor.visitComment(COMMENT_MULTILINE_BEGIN + this.finish(tokens.nextToken()) + COMMENT_MULTILINE_END);
        state.needsBlank = true;
        tokens.setReturnTokens(true);
        tokens.nextToken();
        parent.continueFrom(tokens);
    }

    private void parseCommentLine(ParseState state, WordTokenizer parent) throws IOException, SQLException {
        WordTokenizer tokens = new WordTokenizer(parent, new String[]{"\n", "\r"}, true, true);
        state.visitor.visitComment(COMMENT_LINE + this.finish(tokens.nextToken()));
        state.needsBlank = true;
        parent.continueFrom(tokens);
    }

    private int parseLiteral(ParseState state, WordTokenizer parent) throws IOException {
        WordTokenizer tokens = new WordTokenizer(parent, new String[]{LITERAL}, true, true);
        try {
            String token = tokens.nextToken();
            while (token != null) {
                if (LITERAL.equals(token)) {
                    int next = tokens.nextChar();
                    state.appendSql(LITERAL);
                    if (LITERAL.charAt(0) != (char)next) {
                        int n = next;
                        return n;
                    }
                    state.appendSql(LITERAL);
                } else {
                    state.appendSql(token);
                }
                token = tokens.nextToken();
            }
            throw new IllegalArgumentException("Literal not closed: " + state.sql());
        }
        finally {
            parent.continueFrom(tokens);
        }
    }

    private String finish(String sql) {
        if (this.myEnvReplacer == null) {
            return sql;
        }
        return this.myEnvReplacer.replaceProperties(sql);
    }

    static {
        String[] seps = new String[]{SEMICOLON, "\r", "\n", LITERAL, COMMENT_MULTILINE_BEGIN, COMMENT_LINE, " ", "\t"};
        SQL_SEPARATORS = new String[seps.length + PROCEDURE_OR_TRIGGER.length];
        System.arraycopy(seps, 0, SQL_SEPARATORS, 0, seps.length);
        System.arraycopy(PROCEDURE_OR_TRIGGER, 0, SQL_SEPARATORS, seps.length, PROCEDURE_OR_TRIGGER.length);
        PROCEDURE_SEPARATORS = new String[]{"\n", "\r"};
    }

    class ParseState {
        final ScriptVisitor visitor;
        StringBuilder sqlBuf;
        private StringBuilder currentLine;
        boolean needsBlank;

        ParseState(ScriptVisitor aVisitor) {
            this.visitor = aVisitor;
            this.newBuf();
            this.newLine();
        }

        void newBuf() {
            this.sqlBuf = new StringBuilder();
            this.needsBlank = false;
        }

        void newLine() {
            this.currentLine = new StringBuilder();
        }

        void appendSql(String token) {
            if (this.needsBlank && this.sqlBuf.length() > 0 && this.sqlBuf.charAt(this.sqlBuf.length() - 1) != ' ' && token.charAt(0) != ' ') {
                this.sqlBuf.append(' ');
            }
            this.needsBlank = false;
            this.sqlBuf.append(token);
        }

        void appendPlain(String token) {
            this.currentLine.append(token);
            this.needsBlank = false;
            this.sqlBuf.append(token);
        }

        void appendCurrentSql(String token) {
            this.currentLine.append(token);
            if (!this.isSlashLine()) {
                this.appendSql(token);
            }
        }

        boolean isEmpty() {
            return this.sqlBuf.length() == 0;
        }

        String sql() {
            return this.sqlBuf.toString();
        }

        boolean isSlashLine() {
            return this.currentLine.toString().trim().equals(SQLScriptParser.SLASH);
        }

        boolean procNewLine() throws SQLException {
            boolean result = false;
            if (this.isSlashLine()) {
                String sql = this.sql();
                try {
                    this.execSQL(sql);
                }
                catch (SQLException ex) {
                    SQLScriptParser.this.handleError(ex, sql);
                }
                catch (JdbcException ex) {
                    SQLScriptParser.this.handleError(ex, sql);
                }
                this.newBuf();
                result = true;
            }
            this.newLine();
            return result;
        }

        void visitSql() throws SQLException {
            String sql = this.sql().trim();
            try {
                if ("COMMIT".equalsIgnoreCase(sql)) {
                    this.visitor.doCommit();
                } else if ("ROLLBACK".equalsIgnoreCase(sql)) {
                    this.visitor.doRollback();
                } else {
                    this.execSQL(sql);
                }
            }
            catch (SQLException ex) {
                SQLScriptParser.this.handleError(ex, sql);
            }
            catch (JdbcException ex) {
                SQLScriptParser.this.handleError(ex, sql);
            }
            this.newBuf();
        }

        private void execSQL(String sql) throws SQLException, JdbcException {
            if (sql.length() == 0) {
                return;
            }
            int affected = this.visitor.visitStatement(sql = SQLScriptParser.this.finish(sql));
            if (affected > 0) {
                SQLScriptParser.this.handleAffectedRow(affected, sql);
            }
        }
    }
}

