/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.config.sax;

import com.agimatec.commons.config.ConfigManager;
import com.agimatec.commons.config.FileNode;
import com.agimatec.commons.config.sax.ConfigContentHandler;
import com.agimatec.commons.config.sax.ConfigWriter;
import com.agimatec.commons.config.sax.NodeHandler;
import java.io.PrintWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FileNodeHandler
extends NodeHandler {
    protected ConfigManager myConfigManager;

    public FileNodeHandler(ConfigManager aConfigManager, String aTag) {
        super(aTag);
        this.myConfigManager = aConfigManager;
    }

    protected Class getInstanceClass() {
        return FileNode.class;
    }

    protected void acceptCharacters(ConfigContentHandler docHandler, char[] chars, int offset, int length) {
        FileNode node = (FileNode)docHandler.getCurrentNode();
        node.setFile(this.appendCharacters(node.getFile(), chars, offset, length));
    }

    protected Object startNode(Attributes attr) {
        FileNode node = new FileNode(this.myConfigManager);
        this.setName(node, attr);
        node.setDir(attr.getValue("dir"));
        node.setFile(attr.getValue("file"));
        String value = attr.getValue("relative");
        boolean theRelative = true;
        if (value != null) {
            theRelative = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
        }
        node.setRelative(theRelative);
        return node;
    }

    protected void writeConfig(ConfigWriter writer, Object obj, Object parent, PrintWriter pw, int indent) throws SAXException {
        FileNode node = (FileNode)obj;
        pw.write("<");
        pw.write(this.tag());
        if (node.getName() != null) {
            pw.write(" name=\"");
            pw.write(StringEscapeUtils.escapeXml((String)node.getName()));
            pw.write("\"");
        }
        if (node.getDir() != null) {
            pw.write(" dir=\"");
            pw.write(StringEscapeUtils.escapeXml((String)node.getDir()));
            pw.write("\"");
        }
        if (node.getFile() != null) {
            pw.write(" file=\"");
            pw.write(StringEscapeUtils.escapeXml((String)node.getFile()));
            pw.write("\"");
        }
        String relative = node.getRelative() ? "true" : "false";
        pw.write(" relative=\"");
        pw.write(relative);
        pw.write("\"");
        pw.write("/>");
    }
}

