/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.config.sax;

import com.agimatec.commons.config.LongNode;
import com.agimatec.commons.config.sax.ConfigContentHandler;
import com.agimatec.commons.config.sax.NodeHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class LongNodeHandler
extends NodeHandler {
    public LongNodeHandler(String aTag) {
        super(aTag);
    }

    protected Class getInstanceClass() {
        return LongNode.class;
    }

    protected Object startNode(Attributes attr) throws SAXException {
        LongNode node = new LongNode();
        this.setName(node, attr);
        String value = this.getValue(attr);
        if (value != null) {
            this.setValue(node, value);
        }
        return node;
    }

    protected void acceptCharacters(ConfigContentHandler docHandler, char[] chars, int offset, int length) throws SAXException {
        LongNode node = (LongNode)docHandler.getCurrentNode();
        this.setValue(node, new String(chars, offset, length));
    }

    private void setValue(LongNode node, String stringValue) throws SAXException {
        try {
            node.setValue(Long.parseLong(stringValue));
        }
        catch (NumberFormatException ex) {
            throw new SAXException("not a long: " + stringValue, ex);
        }
    }
}

