/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.generator;

import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.persistence.SerializerPersistencer;
import com.agimatec.sql.meta.persistence.XStreamPersistencer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratorSettings {
    protected String configFile = this.defaultConfigFileName();
    protected String templateDir = "templates";
    protected String destDir = "target";
    protected String dbms = null;
    protected List<String> templates = new ArrayList<String>();
    protected CatalogDescription catalog = null;
    protected boolean noOutputFile = false;
    private Map<String, String> properties = new HashMap<String, String>();

    protected abstract String defaultConfigFileName();

    public boolean parseArgs(String[] args) throws IOException, ClassNotFoundException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-conf".equalsIgnoreCase(arg)) {
                this.configFile = args[++i];
                continue;
            }
            if ("-nconf".equalsIgnoreCase(arg)) {
                this.configFile = null;
                continue;
            }
            if ("-nout".equalsIgnoreCase(arg)) {
                this.noOutputFile = true;
                continue;
            }
            if ("-help".equalsIgnoreCase(arg)) {
                this.printUsage();
                return false;
            }
            if ("-ftldir".equalsIgnoreCase(arg)) {
                this.templateDir = args[++i];
                continue;
            }
            if ("-destdir".equalsIgnoreCase(arg)) {
                this.destDir = args[++i];
                continue;
            }
            if ("-dbms".equalsIgnoreCase(arg)) {
                if (this.dbms != null) {
                    throw new IllegalArgumentException("exactly one -dbms option is required!");
                }
                this.dbms = args[++i];
                continue;
            }
            if ("-ftl".equalsIgnoreCase(arg)) {
                this.templates.add(args[++i]);
                continue;
            }
            if ("-catalog".equalsIgnoreCase(arg)) {
                this.loadCatalog(args[++i]);
                continue;
            }
            if (arg.length() <= 1 || !arg.startsWith("+")) continue;
            String keyValue = arg.substring(1);
            int idx = arg.indexOf("=");
            if (idx <= 0) continue;
            String key = keyValue.substring(0, idx - 1);
            String value = keyValue.substring(idx);
            this.properties.put(key, value);
        }
        this.checkValid();
        return true;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isNoOutputFile() {
        return this.noOutputFile;
    }

    protected void checkValid() {
        if (this.catalog == null) {
            throw new IllegalArgumentException("no catalog description given with option -catalog");
        }
        if (this.dbms == null) {
            throw new IllegalArgumentException("no database given with option -dbms");
        }
    }

    protected void loadCatalog(String catalogFile) throws IOException, ClassNotFoundException {
        if (this.catalog != null) {
            throw new IllegalArgumentException("exactly one -catalog option is required!");
        }
        this.catalog = catalogFile.toLowerCase().endsWith(".xml") ? (CatalogDescription)new XStreamPersistencer().load(new File(catalogFile)) : (CatalogDescription)new SerializerPersistencer().load(new File(catalogFile));
    }

    protected void printUsage() {
        System.out.println("usage: java " + this.getClass().getName() + " -conf " + this.defaultConfigFileName() + " -catalog catalog.xml -ftldir templates -dbms dbms -ftl templateBaseName -destdir targetDirectory");
        System.out.println("Options:\n\t-help \t (optional) print this help");
        System.out.println("\t-conf \t (optional) name of configuration file, default is " + this.defaultConfigFileName());
        System.out.println("\t-nconf \t (optional) use NO configuration file");
        System.out.println("\t-nout \t (optional) do NOT write a default output file (let templates handle output file names)");
        System.out.println("\t-catalog \t (required) path of catalog file to read (xml or dump)");
        System.out.println("\t-ftldir \t (optional) default: templates. Base directory with .ftl templates (in subdirs)");
        System.out.println("\t-dbms \t (required) subdirs of ftldir with database-specific templates, e.g. oracle, postgres");
        System.out.println("\t-ftl\t (required) can appear multiple times. the template base name (without .ftl suffix)");
        System.out.println("\t-destdir\t (optional) default: target. Directory to write output files to.");
        System.out.println("\t+key=value\tA property key and value that the template can access with ${key}");
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public String getDbms() {
        return this.dbms;
    }

    public List<String> getTemplates() {
        return this.templates;
    }

    public CatalogDescription getCatalog() {
        return this.catalog;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public void setDbms(String dbms) {
        this.dbms = dbms;
    }

    public void setCatalog(CatalogDescription catalog) {
        this.catalog = catalog;
    }
}

