/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.database;

import com.agimatec.database.AbstractDbTool;
import com.agimatec.database.DataSetFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUnitDumpTool
extends AbstractDbTool {
    protected static final Logger log = LoggerFactory.getLogger(DbUnitDumpTool.class);

    public void execute() throws SQLException, DatabaseUnitException, IOException, ClassNotFoundException {
        this.connectDbUnit();
        File file = new File(this.dataFile);
        System.out.println("Writing file " + file.getAbsolutePath());
        FileOutputStream out = new FileOutputStream(file);
        try {
            DataSetFactory.createDataSet(this.dataFile).write(this.connection.createDataSet(), out);
        }
        finally {
            out.close();
        }
    }

    public static void main(String[] args) throws Exception {
        DbUnitDumpTool setUp = new DbUnitDumpTool();
        if (!setUp.runMain(args)) {
            System.exit(-1);
        }
    }

    protected boolean runMain(String[] args) throws Exception {
        try {
            if (!this.parseArgs(args)) {
                boolean bl = false;
                return bl;
            }
            this.execute();
        }
        finally {
            this.disconnect();
        }
        return true;
    }

    protected boolean parseArgs(String[] args) {
        try {
            this.connectJdbc(args);
            for (int i = 4; i < args.length; ++i) {
                String each = args[i];
                if (!"-f".equals(each)) continue;
                this.setDataFile(args[++i]);
            }
            return true;
        }
        catch (Exception ex) {
            this.printUsage();
            log.error("invalid parameters", (Throwable)ex);
            return false;
        }
    }

    protected void printUsage() {
        System.out.println("usage:\njava " + this.getClass().getName() + " {driver} {url} {user} {password} [-f {outputDataFile}] ");
    }
}

