/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate;

import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBVersionString
implements Comparable {
    private static final Logger log = LoggerFactory.getLogger(DBVersionString.class);
    private final String fileName;
    private int major;
    private int minor;
    private int increment;
    private String rest;
    private static final String SEPS = ".-_";
    private String lastSep;

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getIncrement() {
        return this.increment;
    }

    public String getRest() {
        return this.rest;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileType() {
        int idx = this.rest.lastIndexOf(46);
        if (idx == -1) {
            return null;
        }
        return this.rest.substring(idx + 1);
    }

    public static DBVersionString fromString(String prefix, String v) {
        if (prefix != null && !v.startsWith(prefix)) {
            return null;
        }
        try {
            return new DBVersionString(prefix, v);
        }
        catch (Exception e) {
            log.warn("error creating instance for " + v + " because " + e.getMessage());
            return null;
        }
    }

    public static DBVersionString fromString(String v) {
        return DBVersionString.fromString(null, v);
    }

    protected DBVersionString(String v) {
        this(null, v);
    }

    protected DBVersionString(String prefix, String v) {
        this.fileName = v;
        this.parse(prefix, v);
    }

    private void parse(String prefix, String v) {
        StringTokenizer tokens;
        String t;
        this.major = 0;
        this.minor = 0;
        this.increment = 0;
        if (prefix != null) {
            v = v.substring(prefix.length());
        }
        if ((t = this.nextNonSep(tokens = new StringTokenizer(v, SEPS, true))) != null && StringUtils.isNumeric((String)t)) {
            this.major = Integer.parseInt(t);
            t = this.nextNonSep(tokens);
            if (t != null && StringUtils.isNumeric((String)t)) {
                this.minor = Integer.parseInt(t);
                t = this.nextNonSep(tokens);
                if (t != null && StringUtils.isNumeric((String)t)) {
                    this.increment = Integer.parseInt(t);
                    t = null;
                    this.lastSep = null;
                }
            }
        } else {
            throw new NumberFormatException("'" + v + "' is not in the valid format for a version");
        }
        if (tokens.hasMoreTokens() || t != null) {
            StringBuilder buf = new StringBuilder();
            if (this.lastSep != null) {
                buf.append(this.lastSep);
            }
            if (t != null) {
                buf.append(t);
            }
            while (tokens.hasMoreTokens()) {
                buf.append(tokens.nextToken());
            }
            this.rest = buf.toString();
        } else {
            this.rest = "";
        }
    }

    private String nextNonSep(StringTokenizer tokens) {
        this.lastSep = null;
        while (tokens.hasMoreTokens()) {
            String t = tokens.nextToken();
            if (!SEPS.contains(t)) {
                return t;
            }
            this.lastSep = t;
        }
        return null;
    }

    public String toString() {
        return this.getVersion() + this.rest;
    }

    public String getVersion() {
        return String.valueOf(this.major) + '.' + this.minor + '.' + this.increment;
    }

    public boolean versionEquals(DBVersionString other) {
        return this.major == other.major && this.minor == other.minor && this.increment == other.increment;
    }

    public boolean isLater(DBVersionString other) {
        if (other == null) {
            return true;
        }
        if (this.major == other.getMajor()) {
            if (this.minor == other.getMinor()) {
                return this.increment > other.getIncrement();
            }
            return this.minor > other.getMinor();
        }
        return this.major > other.getMajor();
    }

    public int compareTo(Object o) {
        DBVersionString v2 = (DBVersionString)o;
        if (this.getMajor() == v2.getMajor()) {
            if (this.getMinor() == v2.getMinor()) {
                if (this.getIncrement() == v2.getIncrement()) {
                    String t1 = this.getFileType();
                    String t2 = v2.getFileType();
                    if ("xml".equalsIgnoreCase(t1) && !"xml".equalsIgnoreCase(t2)) {
                        return -1;
                    }
                    if ("xml".equalsIgnoreCase(t2) && !"xml".equalsIgnoreCase(t1)) {
                        return 1;
                    }
                    return this.getRest().compareTo(v2.getRest());
                }
                return this.getIncrement() - v2.getIncrement();
            }
            return this.getMinor() - v2.getMinor();
        }
        return this.getMajor() - v2.getMajor();
    }
}

