/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate.util;

import com.agimatec.dbmigrate.util.ScriptVisitorDelegate;
import com.agimatec.sql.script.SQLScriptParser;
import com.agimatec.sql.script.ScriptVisitor;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptCapableVisitor
extends ScriptVisitorDelegate {
    private static final Logger log = LoggerFactory.getLogger(SubscriptCapableVisitor.class);
    private final SQLScriptParser parser;

    public SubscriptCapableVisitor(ScriptVisitor nextVisitor, SQLScriptParser parser) {
        super(nextVisitor);
        this.parser = parser;
    }

    public int visitStatement(String statement) throws SQLException {
        if (statement.startsWith("@")) {
            try {
                if (statement.charAt(1) == '>') {
                    this.parser.execSQLScript((ScriptVisitor)this, statement.substring(2));
                } else if (statement.charAt(1) == '|') {
                    this.parser.iterateSQLLines((ScriptVisitor)this, statement.substring(2));
                } else if (statement.charAt(1) == ';') {
                    this.parser.iterateSQLScript((ScriptVisitor)this, statement.substring(2));
                } else {
                    this.parser.iterateSQLScript((ScriptVisitor)this, statement.substring(1));
                }
            }
            catch (Exception e) {
                log.error("error executing subscript: " + statement.substring(1), (Throwable)e);
                throw new SQLException(e.getMessage(), e);
            }
            return 0;
        }
        if (statement.length() > 5 && statement.substring(0, 4).toLowerCase().equals("set ")) {
            if (!this.doSetExpression(statement.substring(4))) {
                super.visitStatement(statement);
            }
            return 0;
        }
        return super.visitStatement(statement);
    }

    private boolean doSetExpression(String expression) {
        StringTokenizer tokens = new StringTokenizer(expression, "=,; ", true);
        String varName = this.nextToken(tokens, expression);
        while (tokens.hasMoreTokens()) {
            String nt = this.nextToken(tokens, expression);
            if (!"=".equals(nt) && !" ".equals(nt)) {
                log.warn("Illegal operator, expected '=' in: " + expression);
                return false;
            }
            if (!"=".equals(nt)) continue;
            break;
        }
        String value = this.nextToken(tokens, expression);
        if (varName == null || value == null) {
            return false;
        }
        if (varName.equals("FAIL_ON_ERROR")) {
            boolean bool = Boolean.parseBoolean(value);
            log.info("SET " + varName + "=" + bool + ";");
            this.parser.setFailOnError(bool);
            return true;
        }
        log.warn("Illegal script set-option: " + expression);
        return false;
    }

    private String nextToken(StringTokenizer tokens, String expression) {
        if (!tokens.hasMoreTokens()) {
            log.warn("Illegal script set-option: " + expression);
            return null;
        }
        return tokens.nextToken();
    }
}

