/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbtransform;

import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias(value="dataType")
public class DataType
implements Cloneable {
    private Integer precision;
    private Boolean precisionEnabled;
    private Integer scale;
    private String typeName;

    public DataType() {
    }

    public DataType deepCopy() {
        try {
            return (DataType)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public DataType(String typeName) {
        this.typeName = typeName;
    }

    public DataType(String typeName, Integer precision) {
        this(typeName, precision, null);
    }

    public DataType(String typeName, Integer precision, Integer scale) {
        this.typeName = typeName;
        this.precision = precision;
        this.scale = scale;
        this.precisionEnabled = true;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Boolean isPrecisionEnabled() {
        return this.precisionEnabled;
    }

    public void setPrecisionEnabled(Boolean precisionEnabled) {
        this.precisionEnabled = precisionEnabled;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public boolean match(DataType dt) {
        return !(!dt.getTypeName().equalsIgnoreCase(this.typeName) || this.precision != null && dt.getPrecision() != null && !this.precision.equals(dt.getPrecision()) || this.scale != null && dt.getScale() != null && !this.scale.equals(dt.getScale()));
    }

    public String toString() {
        return "DataType{typeName='" + this.typeName + '\'' + ", precision=" + this.precision + ", scale=" + this.scale + '}';
    }
}

