/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbtransform.ejb3;

import com.agimatec.dbtransform.ejb3.Ejb3Prototype;
import com.agimatec.sql.meta.ColumnDescription;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Ejb3Attribute
extends Ejb3Prototype {
    private static final Map<String, String> typeNames = new HashMap<String, String>();
    private static final Map<String, String> typeNamesNullable = new HashMap<String, String>();
    private final ColumnDescription column;
    private String javaType;
    private String attributeName;

    public Ejb3Attribute(ColumnDescription column) {
        this.column = column;
    }

    private String toJavaType(ColumnDescription column) {
        String jtype = null;
        if (column.isNullable()) {
            jtype = typeNamesNullable.get(column.getTypeName());
        }
        if (jtype == null) {
            jtype = typeNames.get(column.getTypeName());
        }
        if (jtype == null) {
            return column.getTypeName();
        }
        return jtype;
    }

    public ColumnDescription getColumn() {
        return this.column;
    }

    public void generate() {
        this.attributeName = this.toProperAttributeName(this.column.getColumnName());
        this.javaType = this.isEnumType() ? this.toProperEntityName(this.attributeName) : this.toJavaType(this.column);
    }

    public String getJavaType() {
        return this.javaType;
    }

    public boolean isEnumType() {
        return this.column.getComment() != null && this.column.getComment().toLowerCase().indexOf("enum") > -1;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getGetter() {
        if ("boolean".equals(this.javaType)) {
            return "is" + StringUtils.capitalize((String)this.getAttributeName());
        }
        return "get" + StringUtils.capitalize((String)this.getAttributeName());
    }

    public String getSetter() {
        return "set" + StringUtils.capitalize((String)this.getAttributeName());
    }

    public String toString() {
        return this.attributeName;
    }

    static {
        typeNames.put("INTEGER", "int");
        typeNames.put("SMALLINT", "int");
        typeNames.put("BIGINT", "long");
        typeNames.put("VARCHAR", "String");
        typeNames.put("CHARACTER VARIYING", "String");
        typeNames.put("CHARACTER", "String");
        typeNames.put("TIMESTAMP", "java.sql.Timestamp");
        typeNames.put("DATE", "java.sql.Date");
        typeNames.put("TIME", "java.sql.Time");
        typeNames.put("BOOLEAN", "boolean");
        typeNames.put("TEXT", "String");
        typeNames.put("BYTEA", "byte[]");
        typeNamesNullable.put("INTEGER", "Integer");
        typeNamesNullable.put("SMALLINT", "Integer");
        typeNamesNullable.put("BIGINT", "Long");
        typeNamesNullable.put("BOOLEAN", "Boolean");
    }
}

