/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql;

import com.agimatec.commons.util.StringUtils;
import com.agimatec.sql.SQLClauseParserAbstract;
import com.agimatec.sql.SQLDateFormats;
import java.io.IOException;
import java.io.Writer;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class SQLStringGenerator
extends SQLClauseParserAbstract {
    protected final List params;
    protected int paramIdx;
    private SQLDateFormats df;

    public SQLStringGenerator(String input, Writer output, List aParams) {
        super(input, output);
        this.params = aParams;
        this.paramIdx = 0;
    }

    protected void addParseParamExpression(String aString) {
        throw new RuntimeException("not supported");
    }

    protected void addParseParamBracket(String aString) {
        throw new RuntimeException("not supported");
    }

    protected void foundParamMarker() throws IOException {
        this.handleExpression(false);
        Object value = this.paramIdx < this.params.size() ? this.params.get(this.paramIdx) : null;
        this.handleParam(value);
        ++this.paramIdx;
    }

    protected void handleParam(Object aValue) throws IOException {
        this.addParseExpression(this.toSQLParamString(aValue));
    }

    protected String toSQLParamString(Object value) {
        if (value == null) {
            return "NULL";
        }
        StringBuilder buf = new StringBuilder();
        this.appendSQLParamString(buf, value);
        return buf.toString();
    }

    public void appendSQLParamString(StringBuilder buf, Object value) {
        if (value == null) {
            buf.append("NULL");
            return;
        }
        if (value instanceof Date) {
            if (this.df == null) {
                this.df = new SQLDateFormats();
            }
            if (value instanceof java.sql.Date) {
                buf.append("to_date('");
                buf.append(this.df.DateFormYYYYMMDD.format((Date)value));
                buf.append("', 'YYYY-MM-DD')");
            } else if (value instanceof Timestamp) {
                buf.append("to_date('");
                buf.append(this.df.TimestampFormYYYYMMDDHHmmss.format((Date)value));
                buf.append("', 'YYYY-MM-DD HH24:MI:SS')");
            } else if (value instanceof Time) {
                buf.append("to_date('");
                buf.append(this.df.TimeFormHHMMSS.format((Date)value));
                buf.append("', 'HH24:MI:SS')");
            }
        } else if (value instanceof String) {
            StringUtils.appendSQLLiteral((String)value, buf);
        } else if (value instanceof Collection) {
            Iterator iter = ((Collection)value).iterator();
            while (iter.hasNext()) {
                this.appendSQLParamString(buf, iter.next());
                if (!iter.hasNext()) continue;
                buf.append(',');
            }
        } else {
            buf.append(value);
        }
    }

    public static String asProcedureCall(String sql) {
        return "begin " + sql + ";end;";
    }
}

