/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.mysql;

import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.script.DDLExpressions;
import com.agimatec.sql.meta.script.ExtractExpr;

public class MySqlDDLExpressions
extends DDLExpressions {
    public static final ExtractExpr[] expressions = MySqlDDLExpressions.compileExpressions("com/agimatec/sql/meta/mysql-ddl.xml");

    public ExtractExpr[] getExpressions() {
        return expressions;
    }

    public void equalizeColumn(ColumnDescription cd) {
        if (cd.getTypeName().equalsIgnoreCase("tinyint") && cd.getPrecision() == 1) {
            cd.setTypeName("BIT");
            cd.setPrecision(0);
        } else if (cd.getTypeName().equalsIgnoreCase("bool") || cd.getTypeName().equalsIgnoreCase("boolean")) {
            cd.setTypeName("BIT");
            cd.setPrecision(0);
        }
        if (cd.getDefaultValue() != null && !cd.getDefaultValue().equalsIgnoreCase("NULL") && cd.getTypeName().equalsIgnoreCase("TIMESTAMP")) {
            cd.setNullable(false);
        }
    }

    public String strip(String value) {
        if (value == null) {
            return null;
        }
        int start = 0;
        int end = value.length();
        if (value.startsWith("`")) {
            ++start;
        }
        if (value.endsWith("`")) {
            --end;
        }
        return value.substring(start, end);
    }
}

