/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.dbmigrate.spring;

import com.agimatec.dbmigrate.AutoMigrationTool;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;

class DBCPAdapter {
    private BasicDataSource dataSource;

    DBCPAdapter() {
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = (BasicDataSource)dataSource;
    }

    public void configure(AutoMigrationTool tool) {
        if (this.dataSource != null) {
            if (StringUtils.isNotEmpty((String)this.dataSource.getUsername()) && tool.getEnvironment().get("DB_USER") == null) {
                tool.getEnvironment().put("DB_USER", this.dataSource.getUsername());
            }
            if (StringUtils.isNotEmpty((String)this.dataSource.getPassword()) && tool.getEnvironment().get("DB_PASSWORD") == null) {
                tool.getEnvironment().put("DB_PASSWORD", this.dataSource.getPassword());
            }
            if (StringUtils.isNotEmpty((String)this.dataSource.getUrl()) && tool.getEnvironment().get("DB_URL") == null) {
                tool.getEnvironment().put("DB_URL", this.dataSource.getUrl());
            }
            if (StringUtils.isNotEmpty((String)this.dataSource.getDriverClassName()) && tool.getEnvironment().get("DB_DRIVER") == null) {
                tool.getEnvironment().put("DB_DRIVER", this.dataSource.getDriverClassName());
            }
        }
    }
}

