/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.logo;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class TurtleGraphicsPane {
    private final double width;
    private final double height;
    private double x;
    private double y;
    private double turtleDirection = 90.0;
    private boolean penIsDown = true;
    private boolean showTurtle = true;
    private HtmlColor penColor = HtmlColorUtils.BLACK;
    private List<Rectangle2D.Double> lines = new ArrayList<Rectangle2D.Double>();
    private List<HtmlColor> colors = new ArrayList<HtmlColor>();
    private String message;

    public TurtleGraphicsPane(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.clearScreen();
    }

    public void clearScreen() {
        this.x = this.width / 2.0;
        this.y = -this.height / 2.0;
        this.turtleDirection = 90.0;
        this.lines.clear();
        this.colors.clear();
    }

    private double dtor(double d) {
        return d * Math.PI / 180.0;
    }

    private void drawTurtle(UGraphic uGraphic) {
        if (!this.showTurtle) {
            return;
        }
        UPolygon uPolygon = new UPolygon();
        double d = 2.0;
        double d2 = 4.5 * d;
        uPolygon.addPoint(0.0 * d - d2, 0.0);
        uPolygon.addPoint(0.0 * d - d2, -2.0 * d);
        uPolygon.addPoint(1.0 * d - d2, -2.0 * d);
        uPolygon.addPoint(1.0 * d - d2, -4.0 * d);
        uPolygon.addPoint(2.0 * d - d2, -4.0 * d);
        uPolygon.addPoint(2.0 * d - d2, -6.0 * d);
        uPolygon.addPoint(3.0 * d - d2, -6.0 * d);
        uPolygon.addPoint(3.0 * d - d2, -8.0 * d);
        uPolygon.addPoint(4.0 * d - d2, -8.0 * d);
        uPolygon.addPoint(4.0 * d - d2, -9.0 * d);
        uPolygon.addPoint(5.0 * d - d2, -9.0 * d);
        uPolygon.addPoint(5.0 * d - d2, -8.0 * d);
        uPolygon.addPoint(6.0 * d - d2, -8.0 * d);
        uPolygon.addPoint(6.0 * d - d2, -6.0 * d);
        uPolygon.addPoint(7.0 * d - d2, -6.0 * d);
        uPolygon.addPoint(7.0 * d - d2, -4.0 * d);
        uPolygon.addPoint(8.0 * d - d2, -4.0 * d);
        uPolygon.addPoint(8.0 * d - d2, -2.0 * d);
        uPolygon.addPoint(9.0 * d - d2, -2.0 * d);
        uPolygon.addPoint(9.0 * d - d2, 0.0);
        uPolygon.addPoint(0.0 * d - d2, 0.0);
        double d3 = -this.dtor(this.turtleDirection - 90.0);
        uPolygon.rotate(d3);
        HtmlColor htmlColor = HtmlColorUtils.getColorIfValid("OliveDrab");
        HtmlColor htmlColor2 = HtmlColorUtils.getColorIfValid("MediumSpringGreen");
        uGraphic.apply(new UChangeColor(htmlColor)).apply(new UChangeBackColor(htmlColor2)).apply(new UTranslate(this.x, -this.y)).draw(uPolygon);
    }

    public void showTurtle() {
        this.showTurtle = true;
    }

    public void hideTurtle() {
        this.showTurtle = false;
    }

    public void setPenColor(HtmlColor htmlColor) {
        this.penColor = htmlColor;
    }

    void addLine(double d, double d2, double d3, double d4) {
        this.lines.add(new Rectangle2D.Double(d, d2, d3, d4));
        this.colors.add(this.penColor);
    }

    public void forward(double d) {
        double d2 = this.dtor(this.turtleDirection);
        double d3 = this.x + d * Math.cos(d2);
        double d4 = this.y + d * Math.sin(d2);
        if (this.penIsDown) {
            this.addLine(this.x, this.y, d3, d4);
            this.x = d3;
            this.y = d4;
        } else {
            this.x = d3;
            this.y = d4;
        }
    }

    public void back(double d) {
        this.forward(-d);
    }

    public void left(double d) {
        this.turtleDirection += d;
        while (this.turtleDirection > 360.0) {
            this.turtleDirection -= 360.0;
        }
        while (this.turtleDirection < 0.0) {
            this.turtleDirection += 360.0;
        }
    }

    public void right(double d) {
        this.left(-d);
    }

    public void penUp() {
        this.penIsDown = false;
    }

    public void penDown() {
        this.penIsDown = true;
    }

    public void paint(UGraphic uGraphic) {
        Cloneable cloneable;
        Object object;
        int n = this.lines.size();
        for (int i = 0; i < n; ++i) {
            object = this.colors.get(i);
            cloneable = this.lines.get(i);
            ULine uLine = new ULine(((Rectangle2D.Double)cloneable).width - ((Rectangle2D.Double)cloneable).x, -((Rectangle2D.Double)cloneable).height + ((Rectangle2D.Double)cloneable).y);
            uGraphic.apply(new UChangeColor((HtmlColor)object)).apply(new UTranslate(((Rectangle2D.Double)cloneable).x, -((Rectangle2D.Double)cloneable).y)).draw(uLine);
        }
        this.drawTurtle(uGraphic);
        if (this.message != null) {
            FontConfiguration fontConfiguration = new FontConfiguration(new UFont("", 0, 14), HtmlColorUtils.BLACK, HtmlColorUtils.BLUE);
            object = TextBlockUtils.create(Display.create(this.message), fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            cloneable = object.calculateDimension(uGraphic.getStringBounder());
            double d = ((Dimension2D)cloneable).getHeight();
            object.drawU(uGraphic.apply(new UTranslate(0.0, this.height - d)));
        }
    }

    public void message(String string) {
        this.message = string;
    }
}

