/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.Hideable;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkHat;
import net.sourceforge.plantuml.cucadiagram.LinkMiddleDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockArrow;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.posimo.BezierUtils;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableUtils;
import net.sourceforge.plantuml.svek.ArithmeticStrategySum;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.MinFinder;
import net.sourceforge.plantuml.svek.Oscillator;
import net.sourceforge.plantuml.svek.PointAndAngle;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactory;
import net.sourceforge.plantuml.svek.image.EntityImageNoteLink;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Line
implements Moveable,
Hideable {
    private final String ltail;
    private final String lhead;
    private final Link link;
    private final String startUid;
    private final String endUid;
    private final TextBlock startTailText;
    private final TextBlock endHeadText;
    private final TextBlock noteLabelText;
    private final int lineColor;
    private final int noteLabelColor;
    private final int startTailColor;
    private final int endHeadColor;
    private final StringBounder stringBounder;
    private final Bibliotekon bibliotekon;
    private DotPath dotPath;
    private Positionable startTailLabelXY;
    private Positionable endHeadLabelXY;
    private Positionable noteLabelXY;
    private UDrawable extremity2;
    private UDrawable extremity1;
    private double dx;
    private double dy;
    private boolean opale;
    private Cluster projectionCluster;
    private final GraphvizVersion graphvizVersion;

    public String toString() {
        return super.toString() + " color=" + this.lineColor;
    }

    public Line(String string, String string2, Link link, ColorSequence colorSequence, String string3, String string4, ISkinParam iSkinParam, StringBounder stringBounder, FontConfiguration fontConfiguration, Bibliotekon bibliotekon, GraphvizVersion graphvizVersion) {
        TextBlock textBlock;
        TextBlock textBlock2;
        if (string == null || string2 == null || link == null) {
            throw new IllegalArgumentException();
        }
        this.graphvizVersion = graphvizVersion;
        this.bibliotekon = bibliotekon;
        this.stringBounder = stringBounder;
        this.link = link;
        this.startUid = string;
        this.endUid = string2;
        this.ltail = string3;
        this.lhead = string4;
        this.lineColor = colorSequence.getValue();
        this.noteLabelColor = colorSequence.getValue();
        this.startTailColor = colorSequence.getValue();
        this.endHeadColor = colorSequence.getValue();
        if (link.getLabel() == null) {
            if (this.getLinkArrow() == LinkArrow.NONE) {
                textBlock2 = null;
            } else {
                textBlock = new TextBlockArrow(Direction.RIGHT, fontConfiguration);
                TextBlockArrow textBlockArrow = new TextBlockArrow(Direction.LEFT, fontConfiguration);
                TextBlockArrow textBlockArrow2 = new TextBlockArrow(Direction.UP, fontConfiguration);
                TextBlockArrow textBlockArrow3 = new TextBlockArrow(Direction.DOWN, fontConfiguration);
                textBlock2 = new DirectionalTextBlock(textBlock, textBlockArrow, textBlockArrow2, textBlockArrow3);
            }
        } else {
            double d = string.equals(string2) ? 6.0 : 1.0;
            TextBlock textBlock3 = TextBlockUtils.withMargin(TextBlockUtils.create(link.getLabel(), fontConfiguration, HorizontalAlignment.CENTER, iSkinParam), d, d);
            if (this.getLinkArrow() == LinkArrow.NONE) {
                textBlock2 = textBlock3;
            } else {
                TextBlock textBlock4 = new TextBlockArrow(Direction.RIGHT, fontConfiguration);
                textBlock4 = TextBlockUtils.mergeLR(textBlock3, textBlock4, VerticalAlignment.CENTER);
                TextBlock textBlock5 = new TextBlockArrow(Direction.LEFT, fontConfiguration);
                textBlock5 = TextBlockUtils.mergeLR(textBlock5, textBlock3, VerticalAlignment.CENTER);
                TextBlock textBlock6 = new TextBlockArrow(Direction.UP, fontConfiguration);
                textBlock6 = TextBlockUtils.mergeTB(textBlock6, textBlock3, HorizontalAlignment.CENTER);
                TextBlock textBlock7 = new TextBlockArrow(Direction.DOWN, fontConfiguration);
                textBlock7 = TextBlockUtils.mergeTB(textBlock3, textBlock7, HorizontalAlignment.CENTER);
                textBlock2 = new DirectionalTextBlock(textBlock4, textBlock5, textBlock6, textBlock7);
            }
        }
        textBlock = link.getNote() == null ? null : new EntityImageNoteLink(link.getNote(), link.getNoteColor(), iSkinParam);
        this.noteLabelText = textBlock2 != null && textBlock != null ? (link.getNotePosition() == Position.LEFT ? TextBlockUtils.mergeLR(textBlock, textBlock2, VerticalAlignment.CENTER) : (link.getNotePosition() == Position.RIGHT ? TextBlockUtils.mergeLR(textBlock2, textBlock, VerticalAlignment.CENTER) : (link.getNotePosition() == Position.TOP ? TextBlockUtils.mergeTB(textBlock, textBlock2, HorizontalAlignment.CENTER) : TextBlockUtils.mergeTB(textBlock2, textBlock, HorizontalAlignment.CENTER)))) : (textBlock2 != null ? textBlock2 : (textBlock != null ? textBlock : null));
        this.startTailText = link.getQualifier1() == null ? null : TextBlockUtils.create(Display.getWithNewlines(link.getQualifier1()), fontConfiguration, HorizontalAlignment.CENTER, iSkinParam);
        this.endHeadText = link.getQualifier2() == null ? null : TextBlockUtils.create(Display.getWithNewlines(link.getQualifier2()), fontConfiguration, HorizontalAlignment.CENTER, iSkinParam);
    }

    public boolean hasNoteLabelText() {
        return this.noteLabelText != null;
    }

    private LinkArrow getLinkArrow() {
        return this.link.getLinkArrow();
    }

    public void appendLine(StringBuilder stringBuilder) {
        stringBuilder.append(this.startUid);
        stringBuilder.append("->");
        stringBuilder.append(this.endUid);
        stringBuilder.append("[");
        LinkType linkType = this.link.getType();
        String string = linkType.getSpecificDecorationSvek();
        if (!string.endsWith(",")) {
            string = string + ",";
        }
        stringBuilder.append(string);
        int n = this.link.getLength();
        if (this.link.isInvis() || n != 1) {
            stringBuilder.append("minlen=" + (n - 1));
            stringBuilder.append(",");
        }
        stringBuilder.append("color=\"" + StringUtils.getAsHtml(this.lineColor) + "\"");
        if (this.noteLabelText != null) {
            stringBuilder.append(",");
            stringBuilder.append("label=<");
            Line.appendTable(stringBuilder, this.noteLabelText.calculateDimension(this.stringBounder), this.noteLabelColor);
            stringBuilder.append(">");
        }
        if (this.startTailText != null) {
            stringBuilder.append(",");
            stringBuilder.append("taillabel=<");
            Line.appendTable(stringBuilder, this.startTailText.calculateDimension(this.stringBounder), this.startTailColor);
            stringBuilder.append(">");
        }
        if (this.endHeadText != null) {
            stringBuilder.append(",");
            stringBuilder.append("headlabel=<");
            Line.appendTable(stringBuilder, this.endHeadText.calculateDimension(this.stringBounder), this.endHeadColor);
            stringBuilder.append(">");
        }
        if (this.ltail != null) {
            stringBuilder.append(",");
            stringBuilder.append("ltail=");
            stringBuilder.append(this.ltail);
        }
        if (this.lhead != null) {
            stringBuilder.append(",");
            stringBuilder.append("lhead=");
            stringBuilder.append(this.lhead);
        }
        if (this.link.isInvis()) {
            stringBuilder.append(",");
            stringBuilder.append("style=invis");
        }
        if (!this.link.isConstraint() || this.link.hasTwoEntryPointsSameContainer()) {
            stringBuilder.append("constraint=false,");
        }
        stringBuilder.append("];");
        SvekUtils.println(stringBuilder);
    }

    public String rankSame() {
        if (this.link.getLength() == 1) {
            return "{rank=same; " + this.getStartUid() + "; " + this.getEndUid() + "}";
        }
        return null;
    }

    public static void appendTable(StringBuilder stringBuilder, Dimension2D dimension2D, int n) {
        int n2 = (int)dimension2D.getWidth();
        int n3 = (int)dimension2D.getHeight();
        Line.appendTable(stringBuilder, n2, n3, n);
    }

    public static void appendTable(StringBuilder stringBuilder, int n, int n2, int n3) {
        stringBuilder.append("<TABLE ");
        stringBuilder.append("BGCOLOR=\"" + StringUtils.getAsHtml(n3) + "\" ");
        stringBuilder.append("FIXEDSIZE=\"TRUE\" WIDTH=\"" + n + "\" HEIGHT=\"" + n2 + "\">");
        stringBuilder.append("<TR");
        stringBuilder.append(">");
        stringBuilder.append("<TD");
        stringBuilder.append(">");
        stringBuilder.append("</TD>");
        stringBuilder.append("</TR>");
        stringBuilder.append("</TABLE>");
    }

    public final String getStartUid() {
        if (this.startUid.endsWith(":h")) {
            return this.startUid.substring(0, this.startUid.length() - 2);
        }
        return this.startUid;
    }

    public final String getEndUid() {
        if (this.endUid.endsWith(":h")) {
            return this.endUid.substring(0, this.endUid.length() - 2);
        }
        return this.endUid;
    }

    public UDrawable getExtremity(LinkHat linkHat, LinkDecor linkDecor, SvekUtils.PointListIterator pointListIterator) {
        ExtremityFactory extremityFactory = linkDecor.getExtremityFactory();
        if (extremityFactory != null) {
            Object object = pointListIterator.next();
            Point2D point2D = (Point2D)object.get(0);
            Point2D point2D2 = (Point2D)object.get(1);
            Point2D point2D3 = (Point2D)object.get(2);
            return extremityFactory.createUDrawable(point2D, point2D2, point2D3);
        }
        if (linkDecor != LinkDecor.NONE) {
            final UPolygon uPolygon = new UPolygon((List<Point2D.Double>)pointListIterator.next());
            return new UDrawable(){

                public void drawU(UGraphic uGraphic) {
                    uGraphic.draw(uPolygon);
                }
            };
        }
        return null;
    }

    public void solveLine(String string, int n, MinFinder minFinder) {
        Point2D.Double double_;
        if (this.link.isInvis()) {
            return;
        }
        int n2 = this.getIndexFromColor(string, this.lineColor);
        if (n2 == -1) {
            return;
        }
        if ((n2 = string.indexOf("d=\"", n2)) == -1) {
            throw new IllegalStateException();
        }
        int n3 = string.indexOf("\"", n2 + 3);
        String string2 = string.substring(n2 + 3, n3);
        this.dotPath = new DotPath(string2, n);
        SvekUtils.PointListIterator pointListIterator = new SvekUtils.PointListIterator(string.substring(n3), n);
        LinkType linkType = this.link.getType();
        this.extremity2 = this.getExtremity(linkType.getHat2(), linkType.getDecor2(), pointListIterator);
        this.extremity1 = this.getExtremity(linkType.getHat1(), linkType.getDecor1(), pointListIterator);
        if (this.noteLabelText != null && (double_ = this.getXY(string, this.noteLabelColor, n)) != null) {
            minFinder.manage(double_);
            this.noteLabelXY = TextBlockUtils.asPositionable(this.noteLabelText, this.stringBounder, double_);
        }
        if (this.startTailText != null && (double_ = this.getXY(string, this.startTailColor, n)) != null) {
            minFinder.manage(double_);
            this.startTailLabelXY = TextBlockUtils.asPositionable(this.startTailText, this.stringBounder, double_);
        }
        if (this.endHeadText != null && (double_ = this.getXY(string, this.endHeadColor, n)) != null) {
            minFinder.manage(double_);
            this.endHeadLabelXY = TextBlockUtils.asPositionable(this.endHeadText, this.stringBounder, double_);
        }
        if (!this.isOpalisable()) {
            this.setOpale(false);
        }
    }

    private boolean isOpalisable() {
        return this.dotPath.getBeziers().size() <= 1;
    }

    private Point2D.Double getXY(String string, int n, int n2) {
        int n3 = this.getIndexFromColor(string, n);
        if (n3 == -1) {
            return null;
        }
        return SvekUtils.getMinXY(SvekUtils.extractPointsList(string, n3, n2));
    }

    private int getIndexFromColor(String string, int n) {
        String string2 = "stroke=\"" + StringUtils.getAsHtml(n).toLowerCase() + "\"";
        int n2 = string.indexOf(string2);
        if (n2 != -1) {
            return n2;
        }
        string2 = ";stroke:" + StringUtils.getAsHtml(n).toLowerCase() + ";";
        n2 = string.indexOf(string2);
        if (n2 != -1) {
            return n2;
        }
        string2 = "fill=\"" + StringUtils.getAsHtml(n).toLowerCase() + "\"";
        n2 = string.indexOf(string2);
        if (n2 != -1) {
            return n2;
        }
        Log.info("Cannot find color=" + n + " " + StringUtils.getAsHtml(n).toLowerCase());
        return -1;
    }

    public void drawU(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor) {
        Point2D point2D;
        Object object;
        Object object2;
        if (this.opale) {
            return;
        }
        Url url = this.link.getUrl();
        if (url != null) {
            uGraphic.startUrl(url);
        }
        if (this.link.isAutoLinkOfAGroup()) {
            object2 = this.bibliotekon.getCluster((IGroup)this.link.getEntity1());
            d += ((Cluster)object2).getWidth();
            d -= this.dotPath.getStartPoint().getX() - ((Cluster)object2).getMinX();
        }
        d += this.dx;
        d2 += this.dy;
        if (this.link.isInvis()) {
            return;
        }
        if (this.link.getSpecificColor() != null) {
            htmlColor = this.link.getSpecificColor();
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(null)).apply(new UChangeColor(htmlColor));
        object2 = this.link.getType();
        uGraphic = uGraphic.apply(((LinkType)object2).getStroke());
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (this.projectionCluster != null && this.link.getEntity1() == this.projectionCluster.getGroup()) {
            object = new DotPath(this.dotPath);
            point2D = ((DotPath)object).getStartPoint();
            Point2D point2D2 = this.projectionCluster.getClusterPosition().getProjectionOnFrontier(point2D);
            d3 = point2D2.getX() - point2D.getX();
            d4 = point2D2.getY() - point2D.getY();
            ((DotPath)object).forceStartPoint(point2D2.getX(), point2D2.getY());
            uGraphic.apply(new UTranslate(d, d2)).draw((UShape)object);
        } else if (this.projectionCluster != null && this.link.getEntity2() == this.projectionCluster.getGroup()) {
            object = new DotPath(this.dotPath);
            point2D = ((DotPath)object).getEndPoint();
            Point2D point2D3 = this.projectionCluster.getClusterPosition().getProjectionOnFrontier(point2D);
            d5 = point2D3.getX() - point2D.getX();
            d6 = point2D3.getY() - point2D.getY();
            ((DotPath)object).forceEndPoint(point2D3.getX(), point2D3.getY());
            uGraphic.apply(new UTranslate(d, d2)).draw((UShape)object);
        } else {
            if (this.dotPath == null) {
                Log.info("DotPath is null for " + this);
                return;
            }
            uGraphic.apply(new UTranslate(d, d2)).draw(this.dotPath);
        }
        uGraphic = uGraphic.apply(new UStroke()).apply(new UChangeColor(htmlColor));
        if (this.extremity1 != null) {
            uGraphic = ((LinkType)object2).getDecor1().isFill() ? uGraphic.apply(new UChangeBackColor(htmlColor)) : uGraphic.apply(new UChangeBackColor(null));
            this.extremity1.drawU(uGraphic.apply(new UTranslate(d + d5, d2 + d6)));
        }
        if (this.extremity2 != null) {
            uGraphic = ((LinkType)object2).getDecor2().isFill() ? uGraphic.apply(new UChangeBackColor(htmlColor)) : uGraphic.apply(new UChangeBackColor(null));
            this.extremity2.drawU(uGraphic.apply(new UTranslate(d + d3, d2 + d4)));
        }
        if (this.noteLabelText != null && this.noteLabelXY != null) {
            this.noteLabelText.drawU(uGraphic.apply(new UTranslate(d + this.noteLabelXY.getPosition().getX(), d2 + this.noteLabelXY.getPosition().getY())));
        }
        if (this.startTailText != null) {
            this.startTailText.drawU(uGraphic.apply(new UTranslate(d + this.startTailLabelXY.getPosition().getX(), d2 + this.startTailLabelXY.getPosition().getY())));
        }
        if (this.endHeadText != null) {
            this.endHeadText.drawU(uGraphic.apply(new UTranslate(d + this.endHeadLabelXY.getPosition().getX(), d2 + this.endHeadLabelXY.getPosition().getY())));
        }
        if (((LinkType)object2).getMiddleDecor() != LinkMiddleDecor.NONE) {
            object = this.dotPath.getMiddle();
            double d7 = ((PointAndAngle)object).getAngle();
            double d8 = -d7 * 180.0 / Math.PI;
            UDrawable uDrawable = ((LinkType)object2).getMiddleDecor().getMiddleFactory().createUDrawable(d8 - 45.0);
            uDrawable.drawU(uGraphic.apply(new UTranslate(d + ((PointAndAngle)object).getX(), d2 + ((PointAndAngle)object).getY())));
        }
        if (url != null) {
            uGraphic.closeAction();
        }
    }

    public boolean isInverted() {
        return this.link.isInverted();
    }

    private double getDecorDzeta() {
        LinkType linkType = this.link.getType();
        int n = linkType.getDecor1().getMargin();
        int n2 = linkType.getDecor2().getMargin();
        return n + n2;
    }

    public double getHorizontalDzeta(StringBounder stringBounder) {
        if (this.startUid.equals(this.endUid)) {
            return this.getDecorDzeta();
        }
        if (!this.isHorizontal()) {
            return 0.0;
        }
        ArithmeticStrategySum arithmeticStrategySum = new ArithmeticStrategySum();
        if (this.noteLabelText != null) {
            arithmeticStrategySum.eat(this.noteLabelText.calculateDimension(stringBounder).getWidth());
        }
        if (this.startTailText != null) {
            arithmeticStrategySum.eat(this.startTailText.calculateDimension(stringBounder).getWidth());
        }
        if (this.endHeadText != null) {
            arithmeticStrategySum.eat(this.endHeadText.calculateDimension(stringBounder).getWidth());
        }
        return arithmeticStrategySum.getResult() + this.getDecorDzeta();
    }

    private boolean isHorizontal() {
        return this.link.getLength() == 1;
    }

    public double getVerticalDzeta(StringBounder stringBounder) {
        if (this.startUid.equals(this.endUid)) {
            return this.getDecorDzeta();
        }
        if (this.isHorizontal()) {
            return 0.0;
        }
        ArithmeticStrategySum arithmeticStrategySum = new ArithmeticStrategySum();
        if (this.noteLabelText != null) {
            arithmeticStrategySum.eat(this.noteLabelText.calculateDimension(stringBounder).getHeight());
        }
        if (this.startTailText != null) {
            arithmeticStrategySum.eat(this.startTailText.calculateDimension(stringBounder).getHeight());
        }
        if (this.endHeadText != null) {
            arithmeticStrategySum.eat(this.endHeadText.calculateDimension(stringBounder).getHeight());
        }
        return arithmeticStrategySum.getResult() + this.getDecorDzeta();
    }

    public void manageCollision(Collection<Shape> collection) {
        for (Shape shape : collection) {
            Positionable positionable = PositionableUtils.addMargin(shape, 8.0, 8.0);
            if (this.startTailText != null && this.startTailLabelXY != null && PositionableUtils.intersect(positionable, this.startTailLabelXY)) {
                this.startTailLabelXY = PositionableUtils.moveAwayFrom(positionable, this.startTailLabelXY);
            }
            if (this.endHeadText == null || this.endHeadLabelXY == null || !PositionableUtils.intersect(positionable, this.endHeadLabelXY)) continue;
            this.endHeadLabelXY = PositionableUtils.moveAwayFrom(positionable, this.endHeadLabelXY);
        }
    }

    private void avoid(Point2D.Double double_, Positionable positionable, Shape shape) {
        Oscillator oscillator = new Oscillator();
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        while (this.cut(positionable, shape)) {
            Point2D.Double double_3 = oscillator.nextPosition();
            double_.setLocation(double_2.x + double_3.x, double_2.y + double_3.y);
        }
    }

    private boolean cut(Positionable positionable, Shape shape) {
        return BezierUtils.intersect(positionable, shape) || this.tooClose(positionable);
    }

    private boolean tooClose(Positionable positionable) {
        Dimension2D dimension2D;
        double d = this.dotPath.getMinDist(BezierUtils.getCenter(positionable));
        return d < (dimension2D = positionable.getSize()).getWidth() / 2.0 + 2.0 || d < dimension2D.getHeight() / 2.0 + 2.0;
    }

    @Override
    public void moveSvek(double d, double d2) {
        this.dx += d;
        this.dy += d2;
    }

    public final DotPath getDotPath() {
        DotPath dotPath = new DotPath(this.dotPath);
        dotPath.moveSvek(this.dx, this.dy);
        return dotPath;
    }

    public int getLength() {
        return this.link.getLength();
    }

    public void setOpale(boolean bl) {
        this.link.setOpale(bl);
        this.opale = bl;
    }

    public boolean isOpale() {
        return this.opale;
    }

    public boolean isHorizontalSolitary() {
        return this.link.isHorizontalSolitary();
    }

    public boolean isLinkFromOrTo(IEntity iEntity) {
        return this.link.getEntity1() == iEntity || this.link.getEntity2() == iEntity;
    }

    public boolean hasEntryPoint() {
        return this.link.hasEntryPoint();
    }

    public void setProjectionCluster(Cluster cluster) {
        this.projectionCluster = cluster;
    }

    @Override
    public boolean isHidden() {
        return this.link.isHidden();
    }

    public boolean sameConnections(Line line) {
        return this.link.sameConnections(line.link);
    }

    private boolean isAutolink() {
        return this.link.getEntity1() == this.link.getEntity2();
    }

    public Point2D getMyPoint(IEntity iEntity) {
        if (this.link.getEntity1() == iEntity) {
            return this.moveDelta(this.dotPath.getStartPoint());
        }
        if (this.link.getEntity2() == iEntity) {
            return this.moveDelta(this.dotPath.getEndPoint());
        }
        throw new IllegalArgumentException();
    }

    private Point2D moveDelta(Point2D point2D) {
        return new Point2D.Double(point2D.getX() + this.dx, point2D.getY() + this.dy);
    }

    class DirectionalTextBlock
    implements TextBlock {
        private final TextBlock right;
        private final TextBlock left;
        private final TextBlock up;
        private final TextBlock down;

        DirectionalTextBlock(TextBlock textBlock, TextBlock textBlock2, TextBlock textBlock3, TextBlock textBlock4) {
            this.right = textBlock;
            this.left = textBlock2;
            this.up = textBlock3;
            this.down = textBlock4;
        }

        public void drawU(UGraphic uGraphic) {
            Direction direction = this.getDirection();
            if (Line.this.getLinkArrow() == LinkArrow.BACKWARD) {
                direction = direction.getInv();
            }
            switch (direction) {
                case RIGHT: {
                    this.right.drawU(uGraphic);
                    break;
                }
                case LEFT: {
                    this.left.drawU(uGraphic);
                    break;
                }
                case UP: {
                    this.up.drawU(uGraphic);
                    break;
                }
                case DOWN: {
                    this.down.drawU(uGraphic);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public Dimension2D calculateDimension(StringBounder stringBounder) {
            return this.right.calculateDimension(stringBounder);
        }

        private Direction getDirection() {
            if (Line.this.isAutolink()) {
                double d = Line.this.dotPath.getStartAngle();
                return Direction.LEFT;
            }
            Point2D point2D = Line.this.dotPath.getStartPoint();
            Point2D point2D2 = Line.this.dotPath.getEndPoint();
            double d = Math.atan2(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
            if (d > -0.7853981633974483 && d < 0.7853981633974483) {
                return Direction.DOWN;
            }
            if (d > 2.356194490192345 || d < -2.356194490192345) {
                return Direction.UP;
            }
            return point2D2.getX() > point2D.getX() ? Direction.RIGHT : Direction.LEFT;
        }
    }
}

