/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageArcCircle
extends AbstractEntityImage {
    private final TextBlock name;
    private final TextBlock stereo;

    public EntityImageArcCircle(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        this.name = TextBlockUtils.create(iLeaf.getDisplay(), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.COMPONENT, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.COMPONENT, stereotype), this.getSkinParam().getHyperlinkColor()), HorizontalAlignment.CENTER, iSkinParam);
        this.stereo = stereotype == null || stereotype.getLabel() == null ? null : TextBlockUtils.create(Display.getWithNewlines(stereotype.getLabel()), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.COMPONENT_STEREOTYPE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.COMPONENT_STEREOTYPE, null), this.getSkinParam().getHyperlinkColor()), HorizontalAlignment.CENTER, iSkinParam);
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.getStereoDimension(stringBounder);
        return Dimension2DDouble.mergeTB(dimension2D2, dimension2D);
    }

    private Dimension2D getStereoDimension(StringBounder stringBounder) {
        if (this.stereo == null) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return this.stereo.calculateDimension(stringBounder);
    }

    public final void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getStereoDimension(stringBounder);
        Dimension2D dimension2D2 = this.calculateDimension(stringBounder);
        Dimension2D dimension2D3 = this.name.calculateDimension(stringBounder);
        double d = (dimension2D2.getWidth() - dimension2D3.getWidth()) / 2.0;
        double d2 = dimension2D.getHeight();
        this.name.drawU(uGraphic.apply(new UTranslate(d, d2)));
        if (this.stereo != null) {
            double d3 = (dimension2D2.getWidth() - dimension2D.getWidth()) / 2.0;
            this.stereo.drawU(uGraphic.apply(new UTranslate(d3, 0.0)));
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

