/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockGeneric;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.HeaderLayout;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class EntityImageClassHeader2
extends AbstractEntityImage {
    private final HeaderLayout headerLayout;

    public EntityImageClassHeader2(ILeaf iLeaf, ISkinParam iSkinParam, PortionShower portionShower) {
        super(iLeaf, iSkinParam);
        Object object;
        TextBlock textBlock;
        boolean bl = iLeaf.getEntityType() == LeafType.ABSTRACT_CLASS || iLeaf.getEntityType() == LeafType.INTERFACE;
        HtmlColor htmlColor = SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CLASS, this.getStereo());
        Stereotype stereotype = iLeaf.getStereotype();
        String string = iLeaf.getGeneric();
        FontConfiguration fontConfiguration = new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.CLASS, stereotype), htmlColor, this.getSkinParam().getHyperlinkColor());
        if (bl) {
            fontConfiguration = fontConfiguration.italic();
        }
        TextBlock textBlock2 = TextBlockUtils.withMargin(TextBlockUtils.create(iLeaf.getDisplay(), fontConfiguration, HorizontalAlignment.CENTER, iSkinParam), 3.0, 3.0, 0.0, 0.0);
        TextBlock textBlock3 = stereotype == null || stereotype.getLabel() == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, iLeaf) ? null : TextBlockUtils.withMargin(TextBlockUtils.create(Display.create(stereotype.getLabels()), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype), this.getSkinParam().getHyperlinkColor()), HorizontalAlignment.CENTER, iSkinParam), 1.0, 0.0);
        if (string == null) {
            textBlock = null;
        } else {
            textBlock = TextBlockUtils.create(Display.getWithNewlines(string), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype), iSkinParam.getHyperlinkColor()), HorizontalAlignment.CENTER, iSkinParam);
            textBlock = TextBlockUtils.withMargin(textBlock, 1.0, 1.0);
            object = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.background, stereotype);
            HtmlColor htmlColor2 = SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype);
            textBlock = new TextBlockGeneric(textBlock, (HtmlColor)object, htmlColor2);
            textBlock = TextBlockUtils.withMargin(textBlock, 1.0, 1.0);
        }
        object = portionShower.showPortion(EntityPortion.CIRCLED_CHARACTER, (ILeaf)this.getEntity()) ? TextBlockUtils.withMargin(this.getCircledCharacter(iLeaf, iSkinParam), 4.0, 0.0, 5.0, 5.0) : null;
        this.headerLayout = new HeaderLayout((TextBlock)object, textBlock3, textBlock2, textBlock);
    }

    private TextBlock getCircledCharacter(ILeaf iLeaf, ISkinParam iSkinParam) {
        Stereotype stereotype = iLeaf.getStereotype();
        if (stereotype != null && stereotype.getSprite() != null) {
            return iSkinParam.getSprite(stereotype.getSprite()).asTextBlock(stereotype.getHtmlColor());
        }
        UFont uFont = SkinParamUtils.getFont(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null);
        HtmlColor htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBorder, stereotype);
        if (stereotype != null && stereotype.getCharacter() != '\u0000') {
            return new CircledCharacter(stereotype.getCharacter(), this.getSkinParam().getCircledCharacterRadius(), uFont, stereotype.getHtmlColor(), htmlColor, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (iLeaf.getEntityType() == LeafType.ANNOTATION) {
            return new CircledCharacter('@', this.getSkinParam().getCircledCharacterRadius(), uFont, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeABackground, stereotype), htmlColor, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (iLeaf.getEntityType() == LeafType.ABSTRACT_CLASS) {
            return new CircledCharacter('A', this.getSkinParam().getCircledCharacterRadius(), uFont, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeABackground, stereotype), htmlColor, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (iLeaf.getEntityType() == LeafType.CLASS) {
            return new CircledCharacter('C', this.getSkinParam().getCircledCharacterRadius(), uFont, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeCBackground, stereotype), htmlColor, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (iLeaf.getEntityType() == LeafType.INTERFACE) {
            return new CircledCharacter('I', this.getSkinParam().getCircledCharacterRadius(), uFont, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeIBackground, stereotype), htmlColor, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (iLeaf.getEntityType() == LeafType.ENUM) {
            return new CircledCharacter('E', this.getSkinParam().getCircledCharacterRadius(), uFont, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeEBackground, stereotype), htmlColor, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        assert (false);
        return null;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.headerLayout.getDimension(stringBounder);
    }

    public final void drawU(UGraphic uGraphic) {
        throw new UnsupportedOperationException();
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        this.headerLayout.drawU(uGraphic, d, d2);
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

