/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.image.ContainingEllipse;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UParamNull;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Footprint {
    private final StringBounder stringBounder;

    public Footprint(StringBounder stringBounder) {
        this.stringBounder = stringBounder;
    }

    public ContainingEllipse getEllipse(UDrawable uDrawable, double d) {
        MyUGraphic myUGraphic = new MyUGraphic();
        uDrawable.drawU(myUGraphic);
        List list = myUGraphic.all;
        ContainingEllipse containingEllipse = new ContainingEllipse(d);
        for (Point2D.Double double_ : list) {
            containingEllipse.append(double_);
        }
        return containingEllipse;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyUGraphic
    implements UGraphic {
        private final UTranslate translate;
        private final List<Point2D.Double> all;

        private MyUGraphic(List<Point2D.Double> list, UTranslate uTranslate) {
            this.all = list;
            this.translate = uTranslate;
        }

        @Override
        public boolean isSpecialTxt() {
            return false;
        }

        public MyUGraphic() {
            this(new ArrayList<Point2D.Double>(), new UTranslate());
        }

        @Override
        public UGraphic apply(UChange uChange) {
            if (uChange instanceof UTranslate) {
                return new MyUGraphic(this.all, this.translate.compose((UTranslate)uChange));
            }
            if (uChange instanceof UStroke || uChange instanceof UChangeColor) {
                return new MyUGraphic(this.all, this.translate);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public StringBounder getStringBounder() {
            return Footprint.this.stringBounder;
        }

        @Override
        public UParam getParam() {
            return new UParamNull();
        }

        @Override
        public void draw(UShape uShape) {
            double d = this.translate.getDx();
            double d2 = this.translate.getDy();
            if (uShape instanceof UText) {
                this.drawText(d, d2, (UText)uShape);
            } else if (!(uShape instanceof UHorizontalLine) && !(uShape instanceof ULine)) {
                if (uShape instanceof UImage) {
                    this.drawImage(d, d2, (UImage)uShape);
                } else {
                    throw new UnsupportedOperationException(uShape.getClass().toString());
                }
            }
        }

        @Override
        public ColorMapper getColorMapper() {
            return new ColorMapperIdentity();
        }

        @Override
        public void startUrl(Url url) {
        }

        @Override
        public void closeAction() {
        }

        private void addPoint(double d, double d2) {
            this.all.add(new Point2D.Double(d, d2));
        }

        private void drawText(double d, double d2, UText uText) {
            Dimension2D dimension2D = Footprint.this.stringBounder.calculateDimension(uText.getFontConfiguration().getFont(), uText.getText());
            this.addPoint(d, d2 -= dimension2D.getHeight() - 1.5);
            this.addPoint(d, d2 + dimension2D.getHeight());
            this.addPoint(d + dimension2D.getWidth(), d2);
            this.addPoint(d + dimension2D.getWidth(), d2 + dimension2D.getHeight());
        }

        private void drawImage(double d, double d2, UImage uImage) {
            this.addPoint(d, d2);
            this.addPoint(d, d2 + uImage.getHeight());
            this.addPoint(d + uImage.getWidth(), d2);
            this.addPoint(d + uImage.getWidth(), d2 + uImage.getHeight());
        }

        @Override
        public void flushUg() {
        }
    }
}

