/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.eps.DriverCenteredCharacterEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverDotPathEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverEllipseEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverImageEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverLineEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverPathEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverPolygonEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverRectangleEps;
import net.sourceforge.plantuml.ugraphic.eps.DriverTextEps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UGraphicEps
extends AbstractUGraphic<EpsGraphics>
implements ClipContainer,
UGraphic2 {
    private final StringBounder stringBounder;
    private final EpsStrategy strategyTOBEREMOVED;

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicEps(this);
    }

    protected UGraphicEps(UGraphicEps uGraphicEps) {
        super(uGraphicEps);
        this.stringBounder = uGraphicEps.stringBounder;
        this.strategyTOBEREMOVED = uGraphicEps.strategyTOBEREMOVED;
        this.register(this.strategyTOBEREMOVED);
    }

    public UGraphicEps(ColorMapper colorMapper, EpsStrategy epsStrategy) {
        this(colorMapper, epsStrategy, epsStrategy.creatEpsGraphics());
    }

    private UGraphicEps(ColorMapper colorMapper, EpsStrategy epsStrategy, EpsGraphics epsGraphics) {
        super(colorMapper, epsGraphics);
        this.strategyTOBEREMOVED = epsStrategy;
        this.stringBounder = TextBlockUtils.getDummyStringBounder();
        this.register(epsStrategy);
    }

    private void register(EpsStrategy epsStrategy) {
        this.registerDriver(URectangle.class, new DriverRectangleEps(this));
        this.registerDriver(UText.class, new DriverTextEps(this, epsStrategy));
        this.registerDriver(ULine.class, new DriverLineEps(this));
        this.registerDriver(UPolygon.class, new DriverPolygonEps(this));
        this.registerDriver(UEllipse.class, new DriverEllipseEps());
        this.registerDriver(UImage.class, new DriverImageEps());
        this.registerDriver(UPath.class, new DriverPathEps());
        this.registerDriver(DotPath.class, new DriverDotPathEps());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterEps());
    }

    public void close() {
        this.getEpsGraphics().close();
    }

    public String getEPSCode() {
        return this.getEpsGraphics().getEPSCode();
    }

    public EpsGraphics getEpsGraphics() {
        return (EpsGraphics)this.getGraphicObject();
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public void drawEps(String string, double d, double d2) {
        ((EpsGraphics)this.getGraphicObject()).drawEps(string, d, d2);
    }

    public static String getEpsString(ColorMapper colorMapper, EpsStrategy epsStrategy, UDrawable uDrawable) throws IOException {
        UGraphicEps uGraphicEps = new UGraphicEps(colorMapper, epsStrategy);
        uDrawable.drawU(uGraphicEps);
        return uGraphicEps.getEPSCode();
    }

    public static void copyEpsToFile(ColorMapper colorMapper, UDrawable uDrawable, File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(file);
        EpsStrategy epsStrategy = EpsStrategy.getDefault2();
        printWriter.print(UGraphicEps.getEpsString(colorMapper, epsStrategy, uDrawable));
        printWriter.close();
    }

    @Override
    public void startUrl(Url url) {
        ((EpsGraphics)this.getGraphicObject()).openLink(url.getUrl());
    }

    @Override
    public void closeAction() {
        ((EpsGraphics)this.getGraphicObject()).closeLink();
    }

    @Override
    public void writeImageTOBEMOVED(OutputStream outputStream, String string, int n) throws IOException {
        outputStream.write(this.getEPSCode().getBytes());
    }
}

