/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import de.viaboxx.nlstools.formats.BundleWriter;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.util.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWriterProperties
extends BundleWriter {
    private String charset = null;

    public BundleWriterProperties(Task task, String configFile, MBBundle currentBundle, String outputPath, BundleWriter.FileType fileType, Set<String> allowedLocales) {
        super(task, configFile, currentBundle, outputPath, fileType, allowedLocales);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    protected String suffix() {
        return this.fileType == BundleWriter.FileType.XML ? ".xml" : ".properties";
    }

    protected String getPropertiesHeader(String locale) {
        return " THIS FILE HAS BEEN GENERATED AUTOMATICALLY - DO NOT ALTER!\r\n#\r\n# resource bundle: " + this.getCurrentBundle().getBaseName() + "\r\n" + "# locale: " + locale + "\r\n" + "# interface: " + this.getCurrentBundle().getInterfaceName() + "\r\n" + "#";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeOutputFilePerLocale(String locale) throws IOException {
        String propfile = this.getFileName(locale);
        this.task.log("writing resource file " + propfile, 2);
        this.mkdirs(propfile);
        if (this.getCharset() == null || this.fileType.equals((Object)BundleWriter.FileType.XML)) {
            FileOutputStream stream = new FileOutputStream(propfile);
            try {
                String header = this.getPropertiesHeader(locale);
                this.writeProperties(stream, locale, header);
            }
            finally {
                stream.close();
            }
        }
        Writer writer = FileUtils.openFileWriter(new File(propfile), this.getCharset());
        try {
            String header = this.getPropertiesHeader(locale);
            Properties p = this.createProperties(locale);
            p.store(writer, header);
        }
        finally {
            writer.close();
        }
    }

    protected void writeProperties(OutputStream stream, String aLocale, String header) throws IOException {
        Properties p = this.createProperties(aLocale);
        if (this.fileType.equals((Object)BundleWriter.FileType.XML)) {
            p.storeToXML(stream, header);
        } else {
            p.store(stream, header);
        }
    }
}

