/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.tasks;

import de.viaboxx.nlstools.formats.MBBundlesZipper;
import de.viaboxx.nlstools.formats.MBXMLPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBFile;
import de.viaboxx.nlstools.model.MBText;
import de.viaboxx.nlstools.tasks.CopyBundlesTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateBundlesTask
extends Task {
    private File zipFile;
    private File masterFile;
    private String locales;

    public File getZipFile() {
        return this.zipFile;
    }

    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    public File getMasterFile() {
        return this.masterFile;
    }

    public void setMasterFile(File masterFile) {
        this.masterFile = masterFile;
    }

    public String getLocales() {
        return this.locales;
    }

    public void setLocales(String locales) {
        this.locales = locales;
    }

    public void execute() {
        if (this.zipFile == null) {
            throw new BuildException("zipFile required");
        }
        if (this.masterFile == null) {
            this.masterFile = this.getProject().getBaseDir();
        }
        try {
            FileInputStream fin = new FileInputStream(this.zipFile);
            List<MBFile> files = MBBundlesZipper.unzipFiles(fin);
            fin.close();
            this.updateFiles(files);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void updateFiles(List<MBFile> files) throws IOException {
        Map<String, File> mapping = CopyBundlesTask.readControlFileMapping(this.masterFile);
        Set<String> effectiveLocales = this.parseLocales(this.locales);
        for (MBFile file : files) {
            File outFile = mapping.get(file.getName());
            if (outFile == null) {
                this.getProject().log("skipping " + file.getName() + ", not mapped in " + this.masterFile, 1);
                continue;
            }
            if (!outFile.exists()) {
                this.getProject().log("creating (0) " + outFile);
                FileWriter writer = new FileWriter(outFile);
                if (effectiveLocales.isEmpty()) {
                    this.getProject().log("writing (1) " + outFile);
                    writer.write(file.getContent());
                } else {
                    this.getProject().log("parsing (1)" + file.getName());
                    MBBundles newBundles = (MBBundles)MBXMLPersistencer.getXstream().fromXML(file.getContent());
                    this.filterBundleLocales(newBundles, effectiveLocales);
                    this.getProject().log("writing (2) " + outFile);
                    writer.write(MBXMLPersistencer.getXstream().toXML((Object)newBundles));
                }
                writer.close();
                outFile.setLastModified(file.getLastModified());
                continue;
            }
            this.getProject().log("updating (1) " + outFile);
            FileReader reader = new FileReader(outFile);
            this.getProject().log("parsing (2) " + outFile);
            MBBundles oldBundles = (MBBundles)MBXMLPersistencer.getXstream().fromXML((Reader)reader);
            reader.close();
            MBBundles newBundles = (MBBundles)MBXMLPersistencer.getXstream().fromXML(file.getContent());
            this.copyBundleLocales(newBundles, oldBundles, effectiveLocales);
            this.getProject().log("writing (3) " + outFile);
            FileWriter writer = new FileWriter(outFile);
            MBXMLPersistencer.getXstream().toXML((Object)oldBundles, (Writer)writer);
            writer.close();
            if (outFile.lastModified() >= file.getLastModified()) continue;
            outFile.setLastModified(file.getLastModified());
        }
    }

    private void filterBundleLocales(MBBundles bundles, Set<String> effectiveLocales) {
        if (effectiveLocales == null || effectiveLocales.isEmpty()) {
            return;
        }
        for (MBBundle bundle : bundles.getBundles()) {
            for (MBEntry entry : bundle.getEntries()) {
                Iterator<MBText> textIterator = entry.getTexts().iterator();
                while (textIterator.hasNext()) {
                    MBText text = textIterator.next();
                    if (effectiveLocales.contains(text.getLocale())) continue;
                    textIterator.remove();
                }
            }
        }
    }

    private void copyBundleLocales(MBBundles from, MBBundles to, Set<String> effectiveLocale) {
        for (MBBundle bundle : from.getBundles()) {
            for (MBEntry entry : bundle.getEntries()) {
                for (MBText text : entry.getTexts()) {
                    MBText toText;
                    MBEntry toEntry;
                    MBBundle toBundle;
                    if (effectiveLocale != null && !effectiveLocale.isEmpty() && !effectiveLocale.contains(text.getLocale())) continue;
                    if (to == null) {
                        to = new MBBundles();
                    }
                    if ((toBundle = to.getBundle(bundle.getBaseName())) == null) {
                        toBundle = new MBBundle();
                        toBundle.setBaseName(bundle.getBaseName());
                        toBundle.setInterfaceName(bundle.getInterfaceName());
                        toBundle.setSqldomain(bundle.getSqldomain());
                        to.getBundles().add(toBundle);
                    }
                    if ((toEntry = toBundle.getEntry(entry.getKey())) == null) {
                        toEntry = new MBEntry();
                        toEntry.setDescription(entry.getDescription());
                        toEntry.setKey(entry.getKey());
                        toBundle.getEntries().add(toEntry);
                    }
                    if ((toText = toEntry.getText(text.getLocale())) != null) {
                        toEntry.getTexts().remove(toText);
                    }
                    toEntry.getTexts().add(text);
                    Collections.sort(toEntry.getTexts());
                }
            }
        }
    }

    private Set<String> parseLocales(String locales) {
        if (locales == null) {
            return Collections.EMPTY_SET;
        }
        StringTokenizer tokens = new StringTokenizer(locales, " ,");
        HashSet<String> result = new HashSet<String>();
        while (tokens.hasMoreTokens()) {
            result.add(tokens.nextToken());
        }
        return result;
    }
}

