/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import de.viaboxx.nlstools.formats.BundleWriter;
import de.viaboxx.nlstools.formats.MBJSONPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWriterJson
extends BundleWriter {
    private final String outputFile;

    public BundleWriterJson(Task task, String configFile, MBBundle currentBundle, String outputPath, String outputFile, BundleWriter.FileType fileType, Set<String> allowedLocales) {
        super(task, configFile, currentBundle, outputPath, fileType, allowedLocales);
        this.outputFile = outputFile;
    }

    @Override
    protected void writeOutputFilePerLocale(String locale) throws Exception {
        String jsfile = this.getFileName(locale);
        this.mkdirs(jsfile);
        this.task.log("writing json file " + jsfile, 2);
        Properties merged = null;
        if (!StringUtils.isEmpty((CharSequence)locale)) {
            ArrayList locales = new ArrayList(LocaleUtils.localeLookupList((Locale)LocaleUtils.toLocale((String)locale)));
            Collections.reverse(locales);
            for (Locale loc : locales) {
                Properties p = this.createProperties(loc.toString());
                if (merged == null) {
                    merged = p;
                    continue;
                }
                merged.putAll((Map<?, ?>)p);
            }
        } else {
            merged = this.createProperties(locale);
        }
        MBJSONPersistencer writer = new MBJSONPersistencer(this.fileType == BundleWriter.FileType.JS_PRETTY);
        writer.saveObject(merged, new File(jsfile));
    }

    @Override
    protected StringBuilder buildOutputFileNameBase() {
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.getOutputPath());
        fileName.append("/");
        if (this.outputFile == null) {
            fileName.append(this.getCurrentBundle().getBaseName());
        } else {
            fileName.append(this.outputFile);
        }
        return fileName;
    }

    @Override
    protected String suffix() {
        return ".js";
    }
}

