/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.tasks;

import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AddLocaleTask
extends Task {
    private String from;
    private String to;
    private String locales;

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getLocales() {
        return this.locales;
    }

    public void setLocales(String locales) {
        this.locales = locales;
    }

    public void execute() {
        this.log("Reading Bundles from " + this.from, 2);
        try {
            MBPersistencer persistencer = MBPersistencer.forFile(this.from);
            MBBundles loadedBundles = persistencer.load(new File(this.from));
            if (loadedBundles != null) {
                for (MBBundle bundle : loadedBundles.getBundles()) {
                    for (MBEntry entry : bundle.getEntries()) {
                        StringTokenizer tokens = new StringTokenizer(this.locales, ";");
                        while (tokens.hasMoreTokens()) {
                            String locale = tokens.nextToken();
                            boolean newLocale = true;
                            for (MBText text : entry.getTexts()) {
                                if (!text.getLocale().equals(locale)) continue;
                                newLocale = false;
                            }
                            if (!newLocale) continue;
                            MBText text = new MBText();
                            text.setLocale(locale);
                            text.setValue("");
                            entry.getTexts().add(text);
                        }
                    }
                }
            }
            if (loadedBundles != null) {
                loadedBundles.sort();
            }
            persistencer.save(loadedBundles, new File(this.to));
            this.log("Writing to XML file " + this.to, 2);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

