/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.tasks;

import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class FillLocaleTask
extends Task {
    private File from;
    private File to;
    private String sourceLocale;
    private String targetLocale;
    private String fillOnlyKeysStartingWith;
    private boolean doSetReviewFlag = true;

    public void execute() throws BuildException {
        try {
            MBBundles bundles = MBPersistencer.loadFile(this.from);
            for (MBBundle bundle : bundles.getBundles()) {
                for (MBEntry entry : bundle.getEntries()) {
                    MBText sourceText;
                    MBText text;
                    String key;
                    if (this.fillOnlyKeysStartingWith != null && !(key = entry.getKey()).startsWith(this.fillOnlyKeysStartingWith) || !"".equals((text = entry.getText(this.targetLocale)).getValue()) || (sourceText = entry.getText(this.sourceLocale)) == null) continue;
                    MBText newText = new MBText();
                    newText.setValue(sourceText.getValue());
                    newText.setLocale(this.targetLocale);
                    newText.setReview(this.doSetReviewFlag || text.isReview());
                    entry.getTexts().add(newText);
                    entry.getTexts().remove(text);
                }
            }
            MBPersistencer.saveFile(bundles, this.to);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public File getFrom() {
        return this.from;
    }

    public void setFrom(File from) {
        this.from = from;
    }

    public File getTo() {
        return this.to;
    }

    public void setTo(File to) {
        this.to = to;
    }

    public String getSourceLocale() {
        return this.sourceLocale;
    }

    public void setSourceLocale(String sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    public String getTargetLocale() {
        return this.targetLocale;
    }

    public void setTargetLocale(String targetLocale) {
        this.targetLocale = targetLocale;
    }

    public String getFillOnlyKeysStartingWith() {
        return this.fillOnlyKeysStartingWith;
    }

    public void setFillOnlyKeysStartingWith(String fillOnlyKeysStartingWith) {
        this.fillOnlyKeysStartingWith = fillOnlyKeysStartingWith;
    }

    public boolean isDoSetReviewFlag() {
        return this.doSetReviewFlag;
    }

    public void setDoSetReviewFlag(boolean doSetReviewFlag) {
        this.doSetReviewFlag = doSetReviewFlag;
    }
}

