/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.tasks;

import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import de.viaboxx.nlstools.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Property2XMLConverterTask
extends Task {
    private boolean xml = false;
    private String fromProperty;
    private String to;
    private String locales;
    private String interfaceName = "";
    private String fromCharset = null;

    public String getFromCharset() {
        return this.fromCharset;
    }

    public void setFromCharset(String fromCharset) {
        this.fromCharset = fromCharset;
    }

    public boolean isXml() {
        return this.xml;
    }

    public void setXml(boolean xml) {
        this.xml = xml;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String aInterfaceName) {
        this.interfaceName = aInterfaceName;
    }

    public String getFromProperty() {
        return this.fromProperty;
    }

    public void setFromProperty(String aFromProperty) {
        this.fromProperty = aFromProperty;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String aToXML) {
        this.to = aToXML;
    }

    public String getLocales() {
        return this.locales;
    }

    public void setLocales(String aLocales) {
        this.locales = aLocales;
    }

    public void execute() throws BuildException {
        MBBundles bundles = new MBBundles();
        MBBundle bundle = new MBBundle();
        bundles.getBundles().add(bundle);
        try {
            bundle.setInterfaceName(this.getInterfaceName());
            bundle.setBaseName(this.getInterfacePackage().replace('.', '/') + "/" + this.getPropertyBaseName());
            StringTokenizer tokens = new StringTokenizer(this.getLocales(), ";");
            HashMap<String, Properties> properties = new HashMap<String, Properties>();
            HashSet<Object> allKeys = new HashSet<Object>();
            while (tokens.hasMoreTokens()) {
                FileInputStream stream;
                String fname;
                String eachLocale = tokens.nextToken();
                if (eachLocale.equals("-")) {
                    eachLocale = "";
                }
                Properties prop = new Properties();
                String string = fname = eachLocale.length() > 0 ? this.getFromProperty() + "_" + eachLocale : this.getFromProperty();
                if (!this.xml) {
                    if (this.getFromCharset() == null) {
                        stream = new FileInputStream(fname + ".properties");
                        prop.load(stream);
                        ((InputStream)stream).close();
                    } else {
                        Reader reader = FileUtils.openFileReader(new File(fname + ".properties"), this.getFromCharset());
                        prop.load(reader);
                        reader.close();
                    }
                } else {
                    stream = new FileInputStream(fname + ".xml");
                    prop.loadFromXML(stream);
                    ((InputStream)stream).close();
                }
                properties.put(eachLocale, prop);
                allKeys.addAll(prop.keySet());
            }
            ArrayList allKeysList = new ArrayList(allKeys);
            Collections.sort(allKeysList);
            for (Object anAllKeysList : allKeysList) {
                String key = (String)anAllKeysList;
                MBEntry entry = new MBEntry();
                bundle.getEntries().add(entry);
                entry.setKey(key);
                tokens = new StringTokenizer(this.getLocales(), ";");
                while (tokens.hasMoreTokens()) {
                    Properties prop;
                    String eachLocale = tokens.nextToken();
                    if (eachLocale.equals("-")) {
                        eachLocale = "";
                    }
                    if (!(prop = (Properties)properties.get(eachLocale)).containsKey(key)) continue;
                    MBText text = new MBText();
                    entry.getTexts().add(text);
                    text.setLocale(eachLocale);
                    text.setValue(prop.getProperty(key));
                }
            }
            MBPersistencer.saveFile(bundles, new File(this.getTo()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    protected String getPropertyBaseName() {
        String fullName = this.getFromProperty();
        int idx = (fullName = fullName.replace('\\', '/')).lastIndexOf(47);
        if (idx < 0) {
            return fullName;
        }
        return fullName.substring(idx + 1);
    }

    protected String getInterfacePackage() {
        int idx = this.getInterfaceName().lastIndexOf(46);
        if (idx < 0) {
            return "";
        }
        return this.getInterfaceName().substring(0, idx);
    }
}

