/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.formats.MBTextConverter;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class MBXMLPersistencer
extends MBPersistencer {
    static final XStream xstream = new XStream();

    static void configure(XStream xstream) {
        xstream.processAnnotations(MBBundle.class);
        xstream.processAnnotations(MBBundles.class);
        xstream.processAnnotations(MBEntry.class);
        xstream.registerConverter((Converter)new MBTextConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(MBBundles obj, File target) throws IOException {
        this.mkdirs(target);
        Writer out = FileUtils.openFileWriterUTF8(target);
        try {
            xstream.toXML((Object)obj, out);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBBundles load(File source) throws IOException, ClassNotFoundException {
        Reader reader = FileUtils.openFileReaderUTF8(source);
        try {
            MBBundles mBBundles = (MBBundles)xstream.fromXML(reader);
            return mBBundles;
        }
        finally {
            reader.close();
        }
    }

    public static XStream getXstream() {
        return xstream;
    }

    static {
        MBXMLPersistencer.configure(xstream);
    }
}

