/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import de.viaboxx.nlstools.formats.BundleWriter;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import de.viaboxx.nlstools.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWriterFlexClass
extends BundleWriter {
    private String exampleLocale;

    public BundleWriterFlexClass(Task task, String configFile, MBBundle currentBundle, String outputPath, BundleWriter.FileType fileType, Set<String> allowedLocales) {
        super(task, configFile, currentBundle, outputPath, fileType, allowedLocales);
    }

    public String getExampleLocale() {
        return this.exampleLocale;
    }

    public void setExampleLocale(String exampleLocale) {
        this.exampleLocale = exampleLocale;
    }

    @Override
    protected String suffix() {
        return ".as";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeOutputFiles() throws Exception {
        if (this.currentBundle.getInterfaceName() == null) {
            return;
        }
        String iffile = this.getInterfaceFileName();
        this.task.log("writing flex class to: " + iffile, 2);
        this.mkdirs(iffile);
        Writer out = FileUtils.openFileWriterUTF8(new File(iffile));
        PrintWriter pw = new PrintWriter(out);
        try {
            this.writeStaticIntro(pw);
            if (BundleWriter.FileType.FLEX_SMALL == this.fileType || BundleWriter.FileType.JAVA_ENUM_KEYS == this.fileType) {
                pw.println("// keys not contained (small interface). see .xml source file for possible keys");
            } else if (BundleWriter.FileType.FLEX_FULL == this.fileType) {
                this.writeConstants(pw, this.getCurrentBundle());
            }
            this.writeStaticOutro(pw);
        }
        finally {
            pw.close();
        }
    }

    String getIPackage() {
        String inf = this.currentBundle.getInterfaceName();
        int pidx = inf.lastIndexOf(46);
        if (pidx < 0) {
            return "";
        }
        return inf.substring(0, pidx);
    }

    String getIClass() {
        String inf = this.currentBundle.getInterfaceName();
        int pidx = inf.lastIndexOf(46);
        if (pidx < 0) {
            return inf;
        }
        return inf.substring(pidx + 1);
    }

    private String getInterfaceFileName() {
        StringBuilder fileName = new StringBuilder(this.getInterfacePathName());
        fileName.append("/");
        fileName.append(this.getIClass());
        fileName.append(this.suffix());
        return fileName.toString();
    }

    private String getInterfacePathName() {
        String fileName = this.getOutputPath();
        char lastChar = fileName.charAt(fileName.length() - 1);
        if (lastChar != '\\' && lastChar != '/') {
            fileName = fileName + "/";
        }
        fileName = fileName + this.getIPackage().replace('.', '/');
        return fileName;
    }

    void writeStaticIntro(PrintWriter pw) {
        String str = this.getIPackage();
        if (str != null && str.length() > 0) {
            pw.print("package ");
            pw.print(str);
            pw.println("{");
        }
        pw.println();
        this.writeDoNotAlter(pw);
        pw.print("public class ");
        pw.print(this.getIClass());
        pw.println(" {");
        pw.print("  public static const _BUNDLE_NAME:String = \"");
        pw.print(this.currentBundle.getBaseName());
        pw.println("\";");
        pw.println();
    }

    void writeDoNotAlter(PrintWriter pw) {
        pw.println("/**");
        pw.print(" * contains keys of resource bundle ");
        pw.print(this.currentBundle.getBaseName());
        pw.println('.');
        pw.println(" * THIS FILE HAS BEEN GENERATED AUTOMATICALLY - DO NOT ALTER!");
        pw.println(" */");
    }

    private void writeStaticOutro(PrintWriter pw) {
        pw.println("}");
        this.writeDoNotAlter(pw);
        pw.println("}");
    }

    void writeConstants(PrintWriter pw, MBBundle aBundle) {
        for (MBEntry mbEntry : aBundle.getEntries()) {
            String keyName = mbEntry.getKey();
            Iterator<MBText> texts = mbEntry.getTexts().iterator();
            pw.print("  /** ");
            while (texts.hasNext()) {
                MBText theText = texts.next();
                String lang = theText.getLocale();
                pw.print("{");
                pw.print(lang);
                pw.print("} ");
            }
            MBText xmpl = mbEntry.findExampleText(this.getExampleLocale());
            if (xmpl != null) {
                pw.print(" | ");
                pw.print(xmpl.getLocale());
                pw.print(" = ");
                pw.print(StringEscapeUtils.escapeXml((String)xmpl.getValue()));
            }
            pw.println(" */");
            pw.print("  public static const ");
            String theKey = keyName.replace('.', '_');
            pw.print(theKey);
            pw.print(":String = \"");
            pw.print(keyName);
            pw.println("\";");
        }
    }

    @Override
    protected boolean needsNewFiles() throws FileNotFoundException {
        if (this.currentBundle.getInterfaceName() == null) {
            return false;
        }
        File outfile = new File(this.getInterfaceFileName());
        if (!outfile.exists()) {
            return true;
        }
        File infile = new File(this.configFile);
        if (!infile.exists()) {
            throw new FileNotFoundException(infile + " not found");
        }
        return infile.lastModified() > outfile.lastModified();
    }
}

