/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import de.viaboxx.nlstools.formats.BundleWriter;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import de.viaboxx.nlstools.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWriterJavaInterface
extends BundleWriter {
    private String exampleLocale;

    public BundleWriterJavaInterface(Task task, String configFile, MBBundle currentBundle, String outputPath, BundleWriter.FileType fileType, Set<String> allowedLocales) {
        super(task, configFile, currentBundle, outputPath, fileType, allowedLocales);
    }

    public String getExampleLocale() {
        return this.exampleLocale;
    }

    public void setExampleLocale(String exampleLocale) {
        this.exampleLocale = exampleLocale;
    }

    @Override
    protected String suffix() {
        return ".java";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeOutputFiles() throws Exception {
        if (this.currentBundle.getInterfaceName() == null) {
            return;
        }
        String iffile = this.getInterfaceFileName();
        this.task.log("writing interface to: " + iffile, 2);
        this.mkdirs(iffile);
        Writer out = FileUtils.openFileWriterUTF8(new File(iffile));
        PrintWriter pw = new PrintWriter(out);
        try {
            this.writeStaticIntro(pw);
            if (this.isKeyNotContained()) {
                pw.println("// keys not contained (small interface). see .xml source file for possible keys");
            } else if (this.isKeysContained()) {
                this.writeConstants(pw, this.getCurrentBundle());
            }
            this.writeStaticOutro(pw);
        }
        finally {
            pw.close();
        }
    }

    protected boolean isKeysContained() {
        return BundleWriter.FileType.JAVA_FULL == this.fileType || BundleWriter.FileType.JAVA_FULL_ENUM_KEYS == this.fileType;
    }

    protected boolean isKeyNotContained() {
        return BundleWriter.FileType.JAVA_SMALL == this.fileType || BundleWriter.FileType.JAVA_ENUM_KEYS == this.fileType;
    }

    String getIPackage() {
        String inf = this.currentBundle.getInterfaceName();
        int pidx = inf.lastIndexOf(46);
        if (pidx < 0) {
            return "";
        }
        return inf.substring(0, pidx);
    }

    protected String getIClass() {
        String inf = this.currentBundle.getInterfaceName();
        int pidx = inf.lastIndexOf(46);
        if (pidx < 0) {
            return inf;
        }
        return inf.substring(pidx + 1);
    }

    private String getInterfaceFileName() {
        StringBuilder fileName = new StringBuilder(this.getInterfacePathName());
        fileName.append("/");
        fileName.append(this.getIClass());
        fileName.append(this.suffix());
        return fileName.toString();
    }

    private String getInterfacePathName() {
        String fileName = this.getOutputPath();
        char lastChar = fileName.charAt(fileName.length() - 1);
        if (lastChar != '\\' && lastChar != '/') {
            fileName = fileName + "/";
        }
        fileName = fileName + this.getIPackage().replace('.', '/');
        return fileName;
    }

    protected void writeStaticIntro(PrintWriter pw) {
        String str = this.getIPackage();
        if (str != null && str.length() > 0) {
            pw.print("package ");
            pw.print(str);
            pw.println(";");
        }
        pw.println();
        this.writeDoNotAlter(pw);
        this.writeType(pw);
        pw.println(" {");
        pw.print("  String _BUNDLE_NAME = \"");
        pw.print(this.currentBundle.getBaseName());
        pw.println("\";");
        pw.println();
    }

    protected void writeType(PrintWriter pw) {
        pw.print("public interface ");
        pw.print(this.getIClass());
    }

    protected void writeDoNotAlter(PrintWriter pw) {
        pw.println("/**");
        pw.print(" * contains keys of resource bundle ");
        pw.print(this.currentBundle.getBaseName());
        pw.println('.');
        pw.println(" * THIS FILE HAS BEEN GENERATED AUTOMATICALLY - DO NOT ALTER!");
        pw.println(" */");
    }

    protected void writeStaticOutro(PrintWriter pw) {
        pw.println("}");
        this.writeDoNotAlter(pw);
    }

    void writeConstants(PrintWriter pw, MBBundle aBundle) {
        ArrayList<String> allNames;
        Iterator<MBEntry> iter = aBundle.getEntries().iterator();
        boolean enumerateNames = this.fileType == BundleWriter.FileType.JAVA_ENUM_KEYS || this.fileType == BundleWriter.FileType.JAVA_FULL_ENUM_KEYS;
        ArrayList<String> arrayList = allNames = enumerateNames ? new ArrayList<String>() : null;
        while (iter.hasNext()) {
            MBEntry eachEntry = iter.next();
            String keyName = eachEntry.getKey();
            Iterator<MBText> texts = eachEntry.getTexts().iterator();
            pw.print("  /** ");
            while (texts.hasNext()) {
                MBText theText = texts.next();
                String lang = theText.getLocale();
                pw.print("{");
                pw.print(lang);
                pw.print("} ");
            }
            MBText xmpl = eachEntry.findExampleText(this.getExampleLocale());
            if (xmpl != null) {
                pw.print(" | ");
                pw.print(xmpl.getLocale());
                pw.print(" = ");
                pw.print(StringEscapeUtils.escapeXml((String)xmpl.getValue()));
            }
            pw.println(" */");
            String theKey = this.createKeyName(keyName);
            if (enumerateNames) {
                allNames.add(theKey);
            }
            this.writeKeyValue(pw, theKey, keyName);
        }
        if (enumerateNames) {
            this.writeNameEnumeration(pw, allNames);
        }
    }

    protected void writeKeyValue(PrintWriter pw, String key, String value) {
        pw.print("  String ");
        pw.print(key);
        pw.print(" = \"");
        pw.print(value);
        pw.println("\";");
    }

    protected String createKeyName(String keyName) {
        return keyName.replace('.', '_');
    }

    private void writeNameEnumeration(PrintWriter pw, List<String> allNames) {
        pw.print("  String[] _ALL_KEYS = {");
        Iterator<String> i = allNames.iterator();
        while (i.hasNext()) {
            pw.print(i.next());
            if (!i.hasNext()) continue;
            pw.print(", ");
        }
        pw.println("};");
    }

    @Override
    protected boolean needsNewFiles() throws FileNotFoundException {
        if (this.currentBundle.getInterfaceName() == null) {
            return false;
        }
        File outfile = new File(this.getInterfaceFileName());
        if (!outfile.exists()) {
            return true;
        }
        File infile = new File(this.configFile);
        if (!infile.exists()) {
            throw new FileNotFoundException(infile + " not found");
        }
        return infile.lastModified() > outfile.lastModified();
    }
}

