/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import de.viaboxx.nlstools.model.MBText;

final class MBTextConverter
implements Converter {
    MBTextConverter() {
    }

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext context) {
        MBText text = (MBText)o;
        if (text.getLocale() != null) {
            writer.addAttribute("locale", text.getLocale());
        }
        if (text.isReview()) {
            writer.addAttribute("review", "true");
        }
        if (text.isUseDefault()) {
            writer.addAttribute("useDefault", "true");
        }
        if (text.getValue() != null) {
            writer.setValue(text.getValue());
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        MBText text = new MBText();
        text.setLocale(reader.getAttribute("locale"));
        text.setReview(Boolean.parseBoolean(reader.getAttribute("review")));
        text.setUseDefault(Boolean.parseBoolean(reader.getAttribute("useDefault")));
        text.setValue(reader.getValue());
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("value".equals(reader.getNodeName())) {
                text.setValue(reader.getValue());
            }
            reader.moveUp();
        }
        return text;
    }

    public boolean canConvert(Class aClass) {
        return MBText.class == aClass;
    }
}

