/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import de.viaboxx.nlstools.formats.BundleWriterExcel;
import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;

public class MBExcelPersistencer
extends MBPersistencer {
    private static final int STYLE_BOLD = 1;
    private static final int STYLE_ITALIC = 2;
    private static final int STYLE_REVIEW = 3;
    private static final int STYLE_MISSING = 4;
    private static final int STYLE_DATETIME = 5;
    private HSSFWorkbook wb;
    private HSSFSheet sheet;
    private int rowNum = 0;
    private final Map<Integer, CellStyle> styles = new HashMap<Integer, CellStyle>();
    private BundleWriterExcel bundleWriter;

    private void initStyles(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setBoldweight((short)700);
        style.setFont(font);
        this.styles.put(1, (CellStyle)style);
        style = wb.createCellStyle();
        font = wb.createFont();
        font.setItalic(true);
        style.setFont(font);
        this.styles.put(2, (CellStyle)style);
        style = wb.createCellStyle();
        font = wb.createFont();
        font.setItalic(true);
        font.setColor((short)10);
        style.setFont(font);
        this.styles.put(3, (CellStyle)style);
        style = wb.createCellStyle();
        style.setFillPattern((short)2);
        style.setFillBackgroundColor((short)54);
        style.setFillForegroundColor((short)54);
        this.styles.put(4, (CellStyle)style);
        style = wb.createCellStyle();
        HSSFCreationHelper createHelper = wb.getCreationHelper();
        style.setDataFormat(createHelper.createDataFormat().getFormat("yyyy-dd-mm hh:mm"));
        this.styles.put(5, (CellStyle)style);
    }

    private int writeHeaders(MBBundle bundle) throws IOException {
        int colNum;
        HSSFRow headerRow = this.createRow();
        HSSFCell cell = headerRow.createCell(0);
        cell.setCellStyle(this.styles.get(1));
        cell.setCellValue("Bundle:");
        cell = headerRow.createCell(1);
        cell.setCellStyle(this.styles.get(1));
        cell.setCellValue(bundle.getBaseName());
        cell = headerRow.createCell(3);
        cell.setCellValue("Created: ");
        cell = headerRow.createCell(4);
        cell.setCellValue(new Date());
        cell.setCellStyle(this.styles.get(5));
        headerRow = this.createRow();
        if (null != bundle.getInterfaceName()) {
            cell = headerRow.createCell(0);
            cell.setCellStyle(this.styles.get(2));
            cell.setCellValue("Interface:");
            cell = headerRow.createCell(1);
            cell.setCellStyle(this.styles.get(2));
            cell.setCellValue(bundle.getInterfaceName());
        }
        if (null != bundle.getSqldomain()) {
            cell = headerRow.createCell(2);
            cell.setCellStyle(this.styles.get(2));
            cell.setCellValue("SQLDomain:");
            cell = headerRow.createCell(3);
            cell.setCellStyle(this.styles.get(2));
            cell.setCellValue(bundle.getSqldomain());
        }
        ++this.rowNum;
        headerRow = this.createRow();
        String[] headerCols = new String[]{"Key", "Description"};
        for (int i = 0; i < headerCols.length; ++i) {
            HSSFCell headerCell = headerRow.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headerCols[i]);
            headerCell.setCellStyle(this.styles.get(1));
            headerCell.setCellValue((RichTextString)text);
        }
        int firstCol = colNum = headerCols.length;
        List<String> locales = this.bundleWriter.getLocalesUsed();
        for (String each : locales) {
            HSSFCell headerCell = headerRow.createCell(colNum++);
            HSSFRichTextString text = new HSSFRichTextString(each);
            headerCell.setCellStyle(this.styles.get(1));
            headerCell.setCellValue((RichTextString)text);
        }
        return firstCol;
    }

    private void writeRows(MBBundle bundle, int firstCol) throws IOException {
        List<String> locales = this.bundleWriter.getLocalesUsed();
        for (MBEntry entry : bundle.getEntries()) {
            HSSFRow row = this.createRow();
            HSSFCell cell = row.createCell(0);
            cell.setCellValue((RichTextString)new HSSFRichTextString(entry.getKey()));
            if (entry.getDescription() != null) {
                cell = row.createCell(1);
                cell.setCellValue((RichTextString)new HSSFRichTextString(entry.getDescription()));
            }
            int colNum = firstCol;
            for (String each : locales) {
                MBText text = entry.getText(each);
                if (text != null) {
                    cell = row.createCell(colNum);
                    cell.setCellValue((RichTextString)new HSSFRichTextString(text.getValue()));
                    if (text.isReview()) {
                        cell.setCellStyle(this.styles.get(3));
                    } else if (text.getValue() == null || text.getValue().length() == 0) {
                        cell.setCellStyle(this.styles.get(4));
                    }
                }
                ++colNum;
            }
        }
    }

    private HSSFRow createRow() {
        HSSFRow row = this.sheet.createRow(this.rowNum);
        ++this.rowNum;
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(MBBundles obj, File target) throws IOException {
        this.mkdirs(target);
        FileOutputStream out = new FileOutputStream(target);
        try {
            this.wb = new HSSFWorkbook();
            this.initStyles(this.wb);
            for (MBBundle bundle : obj.getBundles()) {
                this.bundleWriter = new BundleWriterExcel(bundle);
                this.rowNum = 0;
                this.sheet = this.wb.createSheet(bundle.getBaseName().replace('/', '.'));
                this.writeRows(bundle, this.writeHeaders(bundle));
            }
            this.wb.write((OutputStream)out);
        }
        finally {
            this.rowNum = 0;
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBBundles load(File source) throws IOException, ClassNotFoundException {
        FileInputStream in = new FileInputStream(source);
        try {
            MBBundles mBBundles = this.load(in);
            return mBBundles;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBBundles load(InputStream in) throws IOException, ClassNotFoundException {
        try {
            this.wb = new HSSFWorkbook(in);
            MBBundles bundles = new MBBundles();
            int sheetIdx = 0;
            this.sheet = this.wb.getSheetAt(sheetIdx++);
            while (this.sheet != null) {
                MBBundle bundle = new MBBundle();
                if (this.readSheet(bundle)) {
                    bundles.getBundles().add(bundle);
                }
                if (this.wb.getNumberOfSheets() > sheetIdx) {
                    this.sheet = this.wb.getSheetAt(sheetIdx++);
                    continue;
                }
                this.sheet = null;
            }
            MBBundles mBBundles = bundles;
            return mBBundles;
        }
        finally {
            this.rowNum = 0;
        }
    }

    private boolean readSheet(MBBundle bundle) {
        if (this.sheet.getLastRowNum() == 0) {
            return false;
        }
        HSSFRow row = this.sheet.getRow(0);
        if (row.getLastCellNum() < 1 || row.getCell(1) == null) {
            return false;
        }
        bundle.setBaseName(this.getStringValue(row.getCell(1)));
        row = this.sheet.getRow(1);
        if (row != null) {
            if (row.getCell(1) != null) {
                bundle.setInterfaceName(this.getStringValue(row.getCell(1)));
            }
            if (row.getCell(3) != null) {
                bundle.setSqldomain(this.getStringValue(row.getCell(3)));
            }
        }
        int firstCol = 2;
        this.rowNum = 3;
        row = this.sheet.getRow(this.rowNum++);
        int colNum = firstCol;
        ArrayList<String> locales = new ArrayList<String>();
        HSSFCell cell = row.getCell(colNum++);
        while (colNum <= row.getLastCellNum()) {
            if (cell != null) {
                locales.add(this.getStringValue(cell));
            }
            if (row.getLastCellNum() >= colNum) {
                cell = row.getCell(colNum++);
                continue;
            }
            cell = null;
        }
        row = this.sheet.getRow(this.rowNum++);
        while (row != null) {
            if (row.getCell(0) != null) {
                MBEntry entry = new MBEntry();
                bundle.getEntries().add(entry);
                entry.setKey(this.getStringValue(row.getCell(0)));
                if (row.getCell(1) != null) {
                    entry.setDescription(this.getStringValue(row.getCell(1)));
                }
                colNum = firstCol;
                for (String each : locales) {
                    String svalue;
                    if ((cell = row.getCell(colNum++)) == null || !StringUtils.isNotEmpty((CharSequence)(svalue = this.getStringValue(cell))) && cell.getCellStyle().getFillBackgroundColor() != 54 && cell.getCellStyle().getFillForegroundColor() != 54) continue;
                    MBText text = new MBText();
                    text.setLocale(each);
                    text.setValue(svalue);
                    text.setReview(cell.getCellStyle().getFont((Workbook)this.wb).getColor() == 10);
                    entry.getTexts().add(text);
                }
            }
            row = this.sheet.getRow(this.rowNum++);
        }
        return true;
    }

    private String getStringValue(HSSFCell cell) {
        Object value = this.getValue(cell);
        return value == null || value instanceof String ? (String)value : String.valueOf(value);
    }

    private Object getValue(HSSFCell cell) {
        return this.getValue(cell, cell.getCellType());
    }

    private Object getValue(HSSFCell cell, int cellType) {
        switch (cellType) {
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case 2: {
                return this.getValue(cell, cell.getCachedFormulaResultType());
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 5: {
                return cell.getErrorCellValue();
            }
        }
        return null;
    }
}

