/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.tasks;

import de.viaboxx.nlstools.formats.MBPersistencer;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ConvertBundlesTask
extends Task {
    private File from;
    private File to;
    private String options;

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void execute() throws BuildException {
        if (this.from == null) {
            throw new BuildException("'from' file missing");
        }
        if (this.to == null) {
            throw new BuildException("'to' file missing");
        }
        if (!this.from.exists()) {
            throw new BuildException("FileNotFound: 'from' file: " + this.from.getPath() + " does not exist.");
        }
        try {
            this.log("Convert " + this.from.getPath() + " ==> " + this.to.getPath());
            MBPersistencer.saveFile(MBPersistencer.loadFile(this.from), this.to, this.options);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("Bundle file conversion from " + this.from.getPath() + " to " + this.to.getPath() + " failed!", (Throwable)e);
        }
    }

    public File getFrom() {
        return this.from;
    }

    public void setFrom(File from) {
        this.from = from;
    }

    public File getTo() {
        return this.to;
    }

    public void setTo(File to) {
        this.to = to;
    }
}

