/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="bundles")
public class MBBundles
implements Cloneable {
    @XStreamImplicit
    private List<MBBundle> bundles = new ArrayList<MBBundle>();

    public void sort() {
        for (MBBundle each : this.getBundles()) {
            each.sort();
        }
    }

    public List<MBBundle> getBundles() {
        if (this.bundles == null) {
            this.bundles = new ArrayList<MBBundle>();
        }
        return this.bundles;
    }

    public void setBundles(List<MBBundle> bundles) {
        this.bundles = bundles;
    }

    public MBBundle getBundle(String baseName) {
        for (MBBundle each : this.bundles) {
            if ((baseName != null || null != each.getBaseName()) && (baseName == null || !baseName.equals(each.getBaseName()))) continue;
            return each;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MBBundles mbBundles = (MBBundles)o;
        return !(this.bundles == null ? mbBundles.bundles != null : !this.bundles.equals(mbBundles.bundles));
    }

    public MBText findMBTextForLocale(String key, String locale) {
        for (MBBundle bundle : this.getBundles()) {
            for (MBEntry entry : bundle.getEntries()) {
                if (!entry.getKey().equals(key)) continue;
                for (MBText text : entry.getTexts()) {
                    if (!text.getLocale().equals(locale)) continue;
                    return text;
                }
            }
        }
        return null;
    }

    public MBBundles copy() {
        try {
            MBBundles copy = (MBBundles)this.clone();
            copy.setBundles(new ArrayList<MBBundle>(this.getBundles().size()));
            for (MBBundle bundle : this.getBundles()) {
                copy.getBundles().add(bundle.copy());
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void removeEntries() {
        for (MBBundle bundle : this.getBundles()) {
            bundle.removeEntries();
        }
    }

    public Set<String> locales() {
        HashSet<String> locales = new HashSet<String>();
        for (MBBundle bundle : this.getBundles()) {
            locales.addAll(bundle.locales());
        }
        return locales;
    }
}

